/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import xyz.dev_juyoung.cropicker.activities.DirectoryActivity;

public class CroPicker {
    public static final int REQUEST_ALBUM = 3641;
    private static final String EXTRA_PREFIX = "xyz.dev_juyoung.cropicker";
    public static final String EXTRA_INIT_CONFIGS = "xyz.dev_juyoung.cropicker.InitializeConfigs";
    public static final String EXTRA_RESULT_IMAGES = "xyz.dev_juyoung.cropicker.Results";
    private Activity requestedActivity;
    private Intent mIntent;
    private Bundle mOptionBundle;

    public static CroPicker init(@NonNull Activity activity) {
        return new CroPicker(activity);
    }

    private CroPicker(@NonNull Activity activity) {
        this.requestedActivity = activity;
        this.mIntent = new Intent();
        this.mOptionBundle = new Bundle();
        this.mOptionBundle.putBoolean(EXTRA_INIT_CONFIGS, true);
    }

    public CroPicker withOptions(@NonNull Options options) {
        this.mOptionBundle.putAll(options.getOptionBundle());
        return this;
    }

    public void start() {
        this.start(3641);
    }

    public void start(int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)this.requestedActivity, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            throw new RuntimeException("Missing required permission(READ_EXTERNAL_STORAGE). Did you checking required permission?");
        }
        this.requestedActivity.startActivityForResult(this.getIntent((Context)this.requestedActivity), requestCode);
    }

    private Intent getIntent(@NonNull Context context) {
        this.mIntent.setClass(context, DirectoryActivity.class);
        this.mIntent.putExtras(this.mOptionBundle);
        return this.mIntent;
    }

    public static class Options {
        public static final String EXTRA_TOOLBAR_COLOR = "xyz.dev_juyoung.cropicker.ToolbarColor";
        public static final String EXTRA_STATUSBAR_COLOR = "xyz.dev_juyoung.cropicker.StatusBarColor";
        public static final String EXTRA_TOOLBAR_WIDGET_COLOR = "xyz.dev_juyoung.cropicker.ToolbarWidgetColor";
        public static final String EXTRA_TOOLBAR_TITLE_TEXT = "xyz.dev_juyoung.cropicker.ToolbarTitleText";
        public static final String EXTRA_TOOLBAR_BACK_ARROW_DRAWABLE = "xyz.dev_juyoung.cropicker.BackArrowDrawable";
        public static final String EXTRA_TOOLBAR_DONE_DRAWABLE = "xyz.dev_juyoung.cropicker.DoneDrawable";
        public static final String EXTRA_GRID_SPAN_COUNT_OF_ALBUM = "xyz.dev_juyoung.cropicker.GridSpanCountOfAlbum";
        public static final String EXTRA_GRID_SPACING = "xyz.dev_juyoung.cropicker.GridSpacing";
        private Bundle mOptionBundle = new Bundle();

        @NonNull
        private Bundle getOptionBundle() {
            return this.mOptionBundle;
        }

        public void setToolbarColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_COLOR, color2);
        }

        public void setStatusBarColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_STATUSBAR_COLOR, color2);
        }

        public void setToolbarWidgetColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_WIDGET_COLOR, color2);
        }

        public void setToolbarTitle(@Nullable String text) {
            this.mOptionBundle.putString(EXTRA_TOOLBAR_TITLE_TEXT, text);
        }

        public void setToolbarBackArrowDrawable(@DrawableRes int drawable2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_BACK_ARROW_DRAWABLE, drawable2);
        }

        public void setToolbarDoneDrawable(@DrawableRes int drawable2) {
            this.mOptionBundle.putInt(EXTRA_TOOLBAR_DONE_DRAWABLE, drawable2);
        }

        public void setAlbumGridSpanCount(@NonNull int count) {
            this.mOptionBundle.putInt(EXTRA_GRID_SPAN_COUNT_OF_ALBUM, count);
        }

        public void setGridSpacing(@DimenRes int dimenRes) {
            this.mOptionBundle.putInt(EXTRA_GRID_SPACING, dimenRes);
        }
    }
}

