/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.provider.MediaStore;
import java.util.ArrayList;
import java.util.HashSet;
import xyz.dev_juyoung.cropicker.models.Album;
import xyz.dev_juyoung.cropicker.models.Media;

public class MediaStoreProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Album> getAlbums(Context context) {
        ArrayList<Album> albums = new ArrayList<Album>();
        HashSet<Long> bucketIds = new HashSet<Long>();
        String[] projection = new String[]{"bucket_id", "bucket_display_name"};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "bucket_display_name");
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndexOfBucketId = cursor.getColumnIndexOrThrow(projection[0]);
                int columnIndexOfBucketDispName = cursor.getColumnIndexOrThrow(projection[1]);
                do {
                    long bucketId = cursor.getLong(columnIndexOfBucketId);
                    String bucketDispName = cursor.getString(columnIndexOfBucketDispName);
                    if (bucketIds.contains(bucketId)) continue;
                    bucketIds.add(bucketId);
                    Album album = new Album(bucketId, bucketDispName, MediaStoreProvider.lastImageOfAlbum(context, String.valueOf(bucketId)), MediaStoreProvider.countImagesOfAlbum(context, String.valueOf(bucketId)));
                    albums.add(album);
                } while (cursor.moveToNext());
            }
        }
        return albums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Media> getImagesOfAlbum(Context context, String bucketId) {
        ArrayList<Media> medias = new ArrayList<Media>();
        String[] projection = new String[]{"_id", "_data", "_display_name", "mime_type", "orientation"};
        String selection = "bucket_id= ?";
        String[] args = new String[]{bucketId};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, selection, args, "date_added desc");
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndexOfId = cursor.getColumnIndexOrThrow(projection[0]);
                int columnIndexOfData = cursor.getColumnIndexOrThrow(projection[1]);
                int columnIndexOfDispName = cursor.getColumnIndexOrThrow(projection[2]);
                int columnIndexOfMimeType = cursor.getColumnIndexOrThrow(projection[3]);
                int columnIndexOfOrientation = cursor.getColumnIndexOrThrow(projection[4]);
                do {
                    long originId = cursor.getLong(columnIndexOfId);
                    String imagePath = cursor.getString(columnIndexOfData);
                    String displayName = cursor.getString(columnIndexOfDispName);
                    String mimeType = cursor.getString(columnIndexOfMimeType);
                    int orientation = cursor.getInt(columnIndexOfOrientation);
                    Media media = new Media(originId, imagePath, displayName, mimeType, orientation);
                    medias.add(media);
                } while (cursor.moveToNext());
            }
        }
        return medias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lastImageOfAlbum(Context context, String bucketId) {
        String path = null;
        String[] projection = new String[]{"_data"};
        String selection = "bucket_id= ?";
        String[] args = new String[]{bucketId};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, selection, args, "date_added desc");
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex(projection[0]);
                path = cursor.getString(columnIndex);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int countImagesOfAlbum(Context context, String bucketId) {
        int count = 0;
        String[] projection = new String[]{"_data"};
        String selection = "bucket_id= ?";
        String[] args = new String[]{bucketId};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, selection, args, "date_added desc");
            if (cursor != null) {
                count = cursor.getCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getThumbnailPath(Context context, long originId) {
        String path = null;
        ContentResolver resolver = context.getContentResolver();
        int kind = 1;
        String[] projection = new String[]{"_data"};
        try (Cursor cursor = null;){
            cursor = MediaStore.Images.Thumbnails.queryMiniThumbnail((ContentResolver)resolver, (long)originId, (int)kind, (String[])projection);
            if (cursor != null && cursor.moveToFirst()) {
                path = cursor.getString(cursor.getColumnIndexOrThrow(projection[0]));
            }
        }
        return path;
    }
}

