/*
 * Decompiled with CFR 0.152.
 */
package xyz.dev_juyoung.cropicker.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.Window;
import android.widget.Toast;
import butterknife.BindView;
import butterknife.ButterKnife;
import xyz.dev_juyoung.cropicker.Configs;
import xyz.dev_juyoung.cropicker.R;
import xyz.dev_juyoung.cropicker.base.CroPickerApplication;

public class CroPickerActivity
extends AppCompatActivity {
    @BindView(value=2131558523)
    Toolbar toolbar;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void setContentView(@LayoutRes int layoutResID) {
        super.setContentView(layoutResID);
        ButterKnife.bind((Activity)this);
        this.checkInitializeConfigs(this.getIntent());
        this.setupToolbar();
    }

    private void checkInitializeConfigs(@Nullable Intent intent) {
        boolean isSetupConfigs;
        if (intent != null && (isSetupConfigs = intent.getBooleanExtra("xyz.dev_juyoung.cropicker.InitializeConfigs", false))) {
            this.setupConfigs(intent);
        }
    }

    private void setupConfigs(@NonNull Intent intent) {
        Configs.statusColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.colorPrimaryDark));
        Configs.toolbarColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.colorPrimary));
        Configs.toolbarWidgetColor = intent.getIntExtra("xyz.dev_juyoung.cropicker.ToolbarWidgetColor", ContextCompat.getColor((Context)this, (int)R.color.colorWhite));
        Configs.toolbarTitle = intent.getStringExtra("xyz.dev_juyoung.cropicker.ToolbarTitleText");
        Configs.toolbarArrowDrawable = intent.getIntExtra("xyz.dev_juyoung.cropicker.BackArrowDrawable", R.drawable.abc_ic_ab_back_material);
        Configs.toolbarDoneDrawable = intent.getIntExtra("xyz.dev_juyoung.cropicker.DoneDrawable", R.drawable.ic_done_white_24dp);
        Configs.gridSpanCountOfAlbum = intent.getIntExtra("xyz.dev_juyoung.cropicker.GridSpanCountOfAlbum", 2);
        Configs.gridSpacing = intent.getIntExtra("xyz.dev_juyoung.cropicker.GridSpacing", R.dimen.md_grid_spacing);
    }

    public void setupToolbar() {
        this.setStatusBarColor(Configs.statusColor);
        this.toolbar.setBackgroundColor(Configs.toolbarColor);
        this.toolbar.setTitleTextColor(Configs.toolbarWidgetColor);
        Drawable upArrow = ContextCompat.getDrawable((Context)this, (int)Configs.toolbarArrowDrawable);
        upArrow.setColorFilter(Configs.toolbarWidgetColor, PorterDuff.Mode.SRC_ATOP);
        this.toolbar.setNavigationIcon(upArrow);
        this.setSupportActionBar(this.toolbar);
    }

    @TargetApi(value=21)
    private void setStatusBarColor(@ColorInt int color2) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21 && (window = this.getWindow()) != null) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void showMessage(@StringRes int resId) {
        this.showMessage(this.getString(resId));
    }

    public void showMessage(@NonNull String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
    }

    public void progressShow() {
        CroPickerApplication.getInstance().progressShow((Activity)this);
    }

    public void progressDismiss() {
        CroPickerApplication.getInstance().progressDismiss();
    }
}

