/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.quicksocket.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.deftu.quicksocket.common.CloseCode;
import xyz.deftu.quicksocket.common.QuickSocketConstants;
import xyz.deftu.quicksocket.common.exceptions.KeyAlreadyBoundException;
import xyz.deftu.quicksocket.common.packets.PacketBase;
import xyz.deftu.quicksocket.common.utils.QuickSocketJsonHandler;
import xyz.deftu.quicksocket.server.QuickSocketServer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fJ\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J&\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0005J(\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-J\u0016\u0010+\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0018\u0010.\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0016\u0010/\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J\u0018\u00100\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\r2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0013H\u0016J\u0006\u00104\u001a\u00020\u0013J\u0016\u00105\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR/\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lxyz/deftu/quicksocket/server/QuickSocketServer;", "Lorg/java_websocket/server/WebSocketServer;", "address", "Ljava/net/InetSocketAddress;", "encoded", "", "(Ljava/net/InetSocketAddress;Z)V", "getEncoded", "()Z", "packets", "", "", "Ljava/lang/Class;", "Lxyz/deftu/quicksocket/common/packets/PacketBase;", "getPackets", "()Ljava/util/Map;", "packets$delegate", "Lkotlin/Lazy;", "addPacket", "", "identifier", "packet", "handleMessage", "message", "onClose", "conn", "Lorg/java_websocket/WebSocket;", "code", "", "reason", "remote", "onConnectionClosed", "connection", "Lxyz/deftu/quicksocket/common/CloseCode;", "onConnectionOpened", "handshake", "Lorg/java_websocket/handshake/ClientHandshake;", "onError", "ex", "Ljava/lang/Exception;", "onErrorOccurred", "throwable", "", "onMessage", "bytes", "Ljava/nio/ByteBuffer;", "onMessageReceived", "onOpen", "onPacketSent", "data", "Lcom/google/gson/JsonObject;", "onSocketStarted", "onStart", "sendPacket", "QuickSocket"})
public class QuickSocketServer
extends WebSocketServer {
    private final boolean encoded;
    @NotNull
    private final Lazy packets$delegate;

    @JvmOverloads
    public QuickSocketServer(@Nullable InetSocketAddress address, boolean encoded) {
        super(address);
        this.encoded = encoded;
        this.packets$delegate = LazyKt.lazy((Function0)packets.2.INSTANCE);
    }

    public /* synthetic */ QuickSocketServer(InetSocketAddress inetSocketAddress, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inetSocketAddress = new InetSocketAddress(8080);
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(inetSocketAddress, bl);
    }

    public final boolean getEncoded() {
        return this.encoded;
    }

    private final Map<String, Class<? extends PacketBase>> getPackets() {
        Lazy lazy = this.packets$delegate;
        return (Map)lazy.getValue();
    }

    public final void onStart() {
        this.onSocketStarted();
    }

    public final void onOpen(@NotNull WebSocket conn, @NotNull ClientHandshake handshake) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
        this.onConnectionOpened(conn, handshake);
    }

    public final void onClose(@NotNull WebSocket conn, int code, @NotNull String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.onConnectionClosed(conn, CloseCode.Companion.from(code), reason, remote);
    }

    public final void onError(@NotNull WebSocket conn, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.onErrorOccurred(conn, ex);
    }

    public final void onMessage(@NotNull WebSocket conn, @NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = StandardCharsets.UTF_8.decode(bytes).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.decode(bytes).toString()");
        String message = string;
        if (this.encoded) {
            this.handleMessage(message);
        } else {
            this.onMessage(conn, message);
        }
        this.onMessageReceived(conn, bytes);
    }

    public final void onMessage(@NotNull WebSocket conn, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.encoded) {
            this.handleMessage(message);
        } else {
            String string = message;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(message.toByteArray())");
            this.onMessage(conn, byteBuffer);
        }
        this.onMessageReceived(conn, message);
    }

    private final void handleMessage(String message) {
        Constructor<? extends PacketBase> constructor;
        if (!QuickSocketJsonHandler.INSTANCE.getParser().isValidJson(message)) {
            return;
        }
        JsonElement raw = JsonParser.parseString((String)message);
        if (!raw.isJsonObject()) {
            throw new MalformedJsonException(Intrinsics.stringPlus((String)"Expected JsonObject, received ", (Object)raw.getClass().getSimpleName()));
        }
        JsonObject parsed = raw.getAsJsonObject();
        if (!parsed.has("identifier")) {
            return;
        }
        String identifier = parsed.get("identifier").getAsString();
        if (!this.getPackets().containsKey(identifier)) {
            return;
        }
        Class<? extends PacketBase> clazz = this.getPackets().get(identifier);
        Intrinsics.checkNotNull(clazz);
        Class<? extends PacketBase> clz = clazz;
        try {
            constructor = clz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            constructor = null;
        }
        Constructor<? extends PacketBase> constructor2 = constructor;
        if (constructor2 == null) {
            return;
        }
        Constructor<? extends PacketBase> constructor3 = constructor2;
        PacketBase packet = constructor3.newInstance(new Object[0]);
        JsonObject jsonObject = parsed.getAsJsonObject("data");
        if (jsonObject == null) {
            jsonObject = null;
        }
        packet.onPacketReceived(jsonObject);
    }

    public final void addPacket(@NotNull String identifier, @NotNull Class<? extends PacketBase> packet) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        if (this.getPackets().containsKey(identifier)) {
            throw new KeyAlreadyBoundException();
        }
        this.getPackets().put(identifier, packet);
    }

    public final void sendPacket(@NotNull WebSocket connection, @NotNull PacketBase packet) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        JsonObject data = new JsonObject();
        packet.onPacketSent(data);
        JsonObject json = packet.asJson();
        this.onPacketSent(packet, data);
        json.add("data", (JsonElement)data);
        String content = QuickSocketConstants.INSTANCE.getGSON().toJson((JsonElement)json);
        if (this.encoded) {
            connection.send(StandardCharsets.UTF_8.encode(content));
        } else {
            connection.send(content);
        }
    }

    public void onSocketStarted() {
    }

    public void onConnectionOpened(@NotNull WebSocket connection, @NotNull ClientHandshake handshake) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
    }

    public void onConnectionClosed(@NotNull WebSocket connection, @NotNull CloseCode code, @NotNull String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    public void onErrorOccurred(@NotNull WebSocket connection, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
    }

    public void onPacketSent(@NotNull PacketBase packet, @NotNull JsonObject data) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public void onMessageReceived(@NotNull WebSocket connection, @NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
    }

    public void onMessageReceived(@NotNull WebSocket connection, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    @JvmOverloads
    public QuickSocketServer(@Nullable InetSocketAddress address) {
        this(address, false, 2, null);
    }

    @JvmOverloads
    public QuickSocketServer() {
        this(null, false, 3, null);
    }
}

