/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.jrest;

import java.util.ArrayList;
import java.util.List;
import spark.Spark;
import xyz.deftu.jrest.IEndpoint;

public final class JRest {
    private final List<IEndpoint> endpoints = new ArrayList<IEndpoint>();

    public void initialize(int port) {
        Spark.port(port);
        for (IEndpoint endpoint : this.endpoints) {
            this.initializeEndpoint("/", endpoint);
        }
    }

    private void initializeEndpoint(String previous, IEndpoint endpoint) {
        switch (endpoint.getHttpMethod()) {
            case GET: {
                Spark.get(endpoint.getName(previous), endpoint::handle);
                break;
            }
            case POST: {
                Spark.post(endpoint.getName(previous), endpoint::handle);
                break;
            }
            case PUT: {
                Spark.put(endpoint.getName(previous), endpoint::handle);
                break;
            }
            case DELETE: {
                Spark.delete(endpoint.getName(previous), endpoint::handle);
                break;
            }
            case PATCH: {
                Spark.patch(endpoint.getName(previous), endpoint::handle);
            }
        }
        List<IEndpoint> children = endpoint.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IEndpoint child : children) {
                this.initializeEndpoint(endpoint.getName(), child);
            }
        }
    }

    public void addEndpoint(IEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }
}

