/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private static final ByteBuffer EOF = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final Session session;
    private final ByteBufferPool bufferPool;
    private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
    private final long timeoutMs;
    private ByteBuffer activeBuffer = null;
    private SuspendToken suspendToken;
    private State state = State.RESUMED;

    public MessageInputStream(Session session) {
        this(session, -1);
    }

    public MessageInputStream(Session session, int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.session = session;
        this.bufferPool = session instanceof WebSocketSession ? ((WebSocketSession)session).getBufferPool() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendFrame(ByteBuffer framePayload, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending {} chunk: {}", fin ? "final" : "non-final", BufferUtil.toDetailString(framePayload));
        }
        if (this.state == State.CLOSED) {
            return;
        }
        try {
            if (framePayload == null || !framePayload.hasRemaining()) {
                return;
            }
            ByteBuffer copy = this.acquire(framePayload.remaining(), framePayload.isDirect());
            BufferUtil.clearToFill(copy);
            copy.put(framePayload);
            BufferUtil.flipToFlush(copy, 0);
            MessageInputStream messageInputStream = this;
            synchronized (messageInputStream) {
                switch (this.state) {
                    case CLOSED: {
                        return;
                    }
                    case RESUMED: {
                        this.suspendToken = this.session.suspend();
                        this.state = State.SUSPENDED;
                        break;
                    }
                    case SUSPENDED: {
                        throw new IllegalStateException();
                    }
                }
                this.buffers.put(copy);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SuspendToken resume = null;
        MessageInputStream messageInputStream = this;
        synchronized (messageInputStream) {
            switch (this.state) {
                case CLOSED: {
                    return;
                }
                case SUSPENDED: {
                    resume = this.suspendToken;
                    this.suspendToken = null;
                    this.state = State.CLOSED;
                    break;
                }
                case RESUMED: {
                    this.state = State.CLOSED;
                }
            }
            this.buffers.clear();
            this.buffers.offer(EOF);
        }
        if (resume != null) {
            resume.resume();
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void messageComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message completed", new Object[0]);
        }
        this.buffers.offer(EOF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        try {
            if (this.state == State.CLOSED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stream closed", new Object[0]);
                }
                return -1;
            }
            while (this.activeBuffer == null || !this.activeBuffer.hasRemaining()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting {} ms to read", this.timeoutMs);
                }
                if (this.timeoutMs < 0L) {
                    this.activeBuffer = this.buffers.take();
                } else {
                    this.activeBuffer = this.buffers.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
                    if (this.activeBuffer == null) {
                        throw new IOException(String.format("Read timeout: %,dms expired", this.timeoutMs));
                    }
                }
                if (this.activeBuffer != EOF) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reached EOF", new Object[0]);
                }
                this.close();
                return -1;
            }
            int result = this.activeBuffer.get() & 0xFF;
            if (!this.activeBuffer.hasRemaining()) {
                SuspendToken resume = null;
                MessageInputStream messageInputStream = this;
                synchronized (messageInputStream) {
                    switch (this.state) {
                        case CLOSED: {
                            return -1;
                        }
                        case SUSPENDED: {
                            resume = this.suspendToken;
                            this.suspendToken = null;
                            this.state = State.RESUMED;
                            break;
                        }
                        case RESUMED: {
                            throw new IllegalStateException();
                        }
                    }
                }
                if (resume != null) {
                    resume.resume();
                }
            }
            return result;
        }
        catch (InterruptedException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupted while waiting to read", x);
            }
            this.close();
            return -1;
        }
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    private ByteBuffer acquire(int capacity, boolean direct) {
        ByteBuffer buffer = this.bufferPool != null ? this.bufferPool.acquire(capacity, direct) : (direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity));
        return buffer;
    }

    private static enum State {
        RESUMED,
        SUSPENDED,
        CLOSED;

    }
}

