/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.fd;

import java.io.File;
import java.util.Objects;
import xyz.deftu.fd.DownloadCallback;
import xyz.deftu.fd.FileDownloadState;
import xyz.deftu.fd.FileDownloader;
import xyz.deftu.fd.HashingHelper;

class FileDownloaderImpl
implements FileDownloader {
    private DownloadCallback downloadCallback;
    private boolean caches = true;
    private String userAgent;
    private int timeout = 30000;
    private FileDownloadState state;
    private File tempDir;
    private File existingFile;
    private boolean downloaded;
    private File tempFile;
    private boolean doingValidation;
    private boolean failedValidation;

    FileDownloaderImpl() {
    }

    @Override
    public void initialize(File tempDir, File existingFile) {
        if (this.state != null) {
            throw new IllegalStateException("Cannot initialize file downloader after a state has been set.");
        }
        this.tempDir = tempDir;
        this.existingFile = existingFile;
        this.state = FileDownloadState.INITIALIZED;
    }

    @Override
    public void download(String url) {
        if (this.state != FileDownloadState.INITIALIZED) {
            throw new IllegalStateException("Download must take place after initialization");
        }
        this.downloaded = this.downloadCallback.download(this, url);
        this.state = FileDownloadState.DOWNLOADED;
    }

    @Override
    public void validate() {
        if (this.state != FileDownloadState.DOWNLOADED) {
            throw new IllegalStateException("Validation must take place after download.");
        }
        this.doingValidation = true;
        this.failedValidation = Objects.equals(HashingHelper.fetchChecksum(this.tempFile), HashingHelper.fetchChecksum(this.existingFile));
        this.state = FileDownloadState.VALIDATED;
    }

    @Override
    public void complete(File newFile) {
        if (this.state == FileDownloadState.DOWNLOADED || this.state == FileDownloadState.VALIDATED) {
            if (!(!this.downloaded || this.doingValidation && this.failedValidation)) {
                if (this.existingFile != null && this.existingFile.exists()) {
                    this.existingFile.delete();
                }
                if (!this.tempFile.renameTo(newFile)) {
                    throw new IllegalStateException("Failed to move downloaded file.");
                }
                this.state = FileDownloadState.COMPLETED;
            } else if (this.tempFile != null) {
                this.tempFile.delete();
            }
        } else {
            throw new IllegalStateException("Completion must take place after download or validation.");
        }
    }

    @Override
    public DownloadCallback getDownloadCallback() {
        return this.downloadCallback;
    }

    @Override
    public FileDownloader withDownloadCallback(DownloadCallback callback) {
        this.downloadCallback = callback;
        return this;
    }

    @Override
    public boolean isCached() {
        return this.caches;
    }

    @Override
    public FileDownloader withCaches(boolean caches) {
        this.caches = caches;
        return this;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public FileDownloader withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public FileDownloader withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public FileDownloadState getState() {
        return this.state;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public File getTempDir() {
        return this.tempDir;
    }
}

