/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.fd;

import java.io.File;
import java.util.function.Consumer;
import xyz.deftu.fd.Constants;
import xyz.deftu.fd.FileDownloader;
import xyz.deftu.fd.FileDownloaderFactory;

class FileDownloaderFactoryImpl
implements FileDownloaderFactory {
    private boolean caches = true;
    private Consumer<Long> transferCallback = Constants.transferCallback;
    private String userAgent;
    private int timeout = 30000;

    FileDownloaderFactoryImpl() {
    }

    @Override
    public FileDownloader create(File tempDir, File existingFile) {
        return FileDownloader.create(tempDir, existingFile).withCaches(this.caches).withTransferCallback(this.transferCallback).withUserAgent(this.userAgent).withTimeout(this.timeout);
    }

    @Override
    public FileDownloader create(File tempDir) {
        return FileDownloader.create(tempDir).withCaches(this.caches).withUserAgent(this.userAgent).withTimeout(this.timeout);
    }

    @Override
    public FileDownloaderFactory withCaches(boolean caches) {
        this.caches = caches;
        return this;
    }

    @Override
    public FileDownloaderFactory withTransferCallback(Consumer<Long> transferCallback) {
        this.transferCallback = transferCallback;
        return this;
    }

    @Override
    public FileDownloaderFactory withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public FileDownloaderFactory withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

