/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.eventbus;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import xyz.deftu.eventbus.Event;
import xyz.deftu.eventbus.EventData;
import xyz.deftu.eventbus.EventPriority;
import xyz.deftu.eventbus.PseudoSubscriber;
import xyz.deftu.eventbus.SubscribeEvent;
import xyz.deftu.eventbus.SubscriberDepth;
import xyz.deftu.eventbus.access.LegacyObjectAccessor;
import xyz.deftu.eventbus.access.ModernObjectAccessor;

public class SimpleEventBus {
    private static final SimpleEventBus GLOBAL_BUS = new SimpleEventBus();
    private static String JAVA_VERSION = System.getProperty("java.version");
    private final Map<Class<? extends Event>, List<EventData>> registry = new HashMap<Class<? extends Event>, List<EventData>>();

    private boolean isBadMethod(Method method) {
        return method.getParameterTypes().length != 1 || !method.isAnnotationPresent(SubscribeEvent.class);
    }

    private void sortList(Class<? extends Event> clazz) {
        ArrayList<EventData> flexible = new ArrayList<EventData>();
        for (EventPriority priority : EventPriority.values()) {
            for (EventData data : this.registry.get(clazz)) {
                if (data.priority != priority) continue;
                flexible.add(data);
            }
        }
        this.registry.put(clazz, flexible);
    }

    public void cleanRegistry() {
        this.registry.entrySet().removeIf(entry -> entry.getValue() == null || ((List)entry.getValue()).isEmpty());
    }

    private void makeAccessible(AccessibleObject object) {
        if (JAVA_VERSION == null) {
            JAVA_VERSION = System.getProperty("java.version");
        }
        if (JAVA_VERSION.startsWith("1.6.") || JAVA_VERSION.startsWith("1.7.") || JAVA_VERSION.startsWith("1.8.")) {
            LegacyObjectAccessor.setAccessible(object);
        } else {
            ModernObjectAccessor.setAccessible(object);
        }
    }

    private void register(Class<? extends Event> event, Method method, Object instance) {
        final EventData data = new EventData(instance, method, method.getAnnotation(SubscribeEvent.class).priority());
        this.makeAccessible(data.target);
        if (this.registry.containsKey(event)) {
            if (!this.registry.get(event).contains(data)) {
                this.registry.get(event).add(data);
                this.sortList(event);
            }
        } else {
            this.registry.put(event, (List<EventData>)new ArrayList<EventData>(){
                {
                    this.add(data);
                }
            });
        }
    }

    private void registerReflection(Object instance, Method method) {
        this.makeAccessible(method);
        if (!this.isBadMethod(method)) {
            this.register(method.getParameterTypes()[0], method, instance);
        }
    }

    private void registerInterface(Object instance, Class<?> clazz) {
        for (Class<?> inter : clazz.getInterfaces()) {
            Class<?> interSup = inter.getSuperclass();
            for (Method method : inter.getDeclaredMethods()) {
                this.registerReflection(instance, method);
            }
            while (interSup != null && (interSup = interSup.getSuperclass()) != null) {
                for (Method method : interSup.getDeclaredMethods()) {
                    this.registerReflection(instance, method);
                }
            }
            this.registerInterface(instance, inter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void register(Object instance, SubscriberDepth depth) {
        Objects.requireNonNull(instance);
        Class<?> clazz = instance.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            this.registerReflection(instance, method);
        }
        if (depth == SubscriberDepth.SUPER) {
            for (Method method : clazz.getSuperclass().getDeclaredMethods()) {
                this.registerReflection(instance, method);
            }
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                for (Method method : ((Class)genericDeclaration).getDeclaredMethods()) {
                    this.registerReflection(instance, method);
                }
            }
        }
        if (depth == SubscriberDepth.DEEP_SUPER) {
            void var7_14;
            Class<?> sup = clazz.getSuperclass();
            Method[] methodArray = sup.getDeclaredMethods();
            int n = methodArray.length;
            boolean bl = false;
            while (var7_14 < n) {
                Method method = methodArray[var7_14];
                this.registerReflection(instance, method);
                ++var7_14;
            }
            while ((sup = sup.getSuperclass()) != null) {
                for (Method method : sup.getDeclaredMethods()) {
                    this.registerReflection(instance, method);
                }
            }
            this.registerInterface(instance, clazz);
        }
    }

    public void register(Object instance) {
        this.register(instance, SubscriberDepth.NONE);
    }

    public <T extends Event> void register(Class<T> clazz, Consumer<T> processor) {
        try {
            PseudoSubscriber<T> subscriber = new PseudoSubscriber<T>(processor);
            this.register(clazz, subscriber.getClass().getDeclaredMethod("onEvent", Event.class), subscriber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(Object instance) {
        for (List<EventData> value : this.registry.values()) {
            value.removeIf(data -> data.source.equals(instance));
        }
        this.cleanRegistry();
    }

    public void post(Event event) {
        try {
            List<EventData> registered = this.registry.get(event.getClass());
            if (registered != null) {
                for (EventData data : this.registry.get(event.getClass())) {
                    data.target.invoke(data.source, event);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<Class<? extends Event>, List<EventData>> getRegistry() {
        return this.registry;
    }

    public static SimpleEventBus getGlobalBus() {
        return GLOBAL_BUS;
    }
}

