/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.eventbus;

import xyz.deftu.eventbus.Cancellable;
import xyz.deftu.eventbus.CancellableEvent;

public abstract class Event {
    private boolean cancelled;

    public boolean isCancellable() {
        return this instanceof CancellableEvent || this.getClass().isAnnotationPresent(Cancellable.class);
    }

    public boolean isCancelled() {
        if (!this.isCancellable()) {
            return false;
        }
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        if (!this.isCancellable()) {
            throw new IllegalArgumentException("Cannot cancel an uncancellable event!");
        }
        this.cancelled = cancelled;
    }

    public void cancel() {
        if (!this.isCancellable()) {
            throw new IllegalArgumentException("Cannot cancel an uncancellable event!");
        }
        this.setCancelled(true);
    }

    public void uncancel() {
        if (!this.isCancellable()) {
            throw new IllegalArgumentException("Cannot uncancel an uncancellable event!");
        }
        this.setCancelled(false);
    }
}

