/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils.functions.abstraction;

import java.util.function.Consumer;
import java.util.function.Supplier;
import xyz.deftu.deftils.functions.Filter;
import xyz.deftu.deftils.functions.Provider;

public abstract class AbstractProvider<T>
implements Provider<T> {
    private T value;

    public AbstractProvider(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public AbstractProvider<T> set(T value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean present() {
        return this.value != null;
    }

    @Override
    public AbstractProvider<T> ifPresent(Consumer<T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
        return this;
    }

    @Override
    public AbstractProvider<T> filter(Filter<? super T> filter) {
        if (this.value == null) {
            return this;
        }
        return filter.check(this.value) ? this : null;
    }

    @Override
    public T or(T other) {
        return this.value != null ? this.value : other;
    }

    @Override
    public <E extends Throwable> AbstractProvider<T> orThrow(Supplier<? extends E> supplier) throws E {
        if (this.value == null) {
            throw (Throwable)supplier.get();
        }
        return this;
    }
}

