/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils.functions;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import xyz.deftu.deftils.functions.Filter;
import xyz.deftu.deftils.functions.impl.ImmutableProvider;
import xyz.deftu.deftils.functions.impl.MutableProvider;

public interface Provider<T> {
    default public boolean isMutable() {
        return this instanceof MutableProvider;
    }

    default public boolean isImmutable() {
        return !this.isMutable();
    }

    public T get();

    public Provider<T> set(T var1);

    public boolean present();

    public Provider<T> ifPresent(Consumer<T> var1);

    public Provider<T> filter(Filter<? super T> var1);

    public T or(T var1);

    public <E extends Throwable> Provider<T> orThrow(Supplier<? extends E> var1) throws E;

    default public Optional<T> asOptional() {
        return this.present() ? Optional.of(this.get()) : Optional.empty();
    }

    public static <T> Provider<T> empty(boolean immutable) {
        return immutable ? new ImmutableProvider<Object>(null) : new MutableProvider();
    }

    public static <T> Provider<T> empty() {
        return Provider.empty(false);
    }

    public static <T> Provider<T> of(boolean immutable, T value) {
        return immutable ? new ImmutableProvider<T>(value) : new MutableProvider<T>(value);
    }

    public static <T> Provider<T> of(T value) {
        return Provider.of(false, value);
    }
}

