/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils.data;

import java.awt.Color;
import xyz.deftu.deftils.Numbers;
import xyz.deftu.deftils.data.Vec3;

public class Colour {
    public static final Colour WHITE = Colour.of(Color.WHITE);
    public static final Colour LIGHT_GRAY = Colour.of(Color.LIGHT_GRAY);
    public static final Colour GRAY = Colour.of(Color.GRAY);
    public static final Colour DARK_GRAY = Colour.of(Color.DARK_GRAY);
    public static final Colour BLACK = Colour.of(Color.BLACK);
    public static final Colour RED = Colour.of(Color.RED);
    public static final Colour PINK = Colour.of(Color.PINK);
    public static final Colour ORANGE = Colour.of(Color.ORANGE);
    public static final Colour YELLOW = Colour.of(Color.YELLOW);
    public static final Colour GREEN = Colour.of(Color.GREEN);
    public static final Colour MAGENTA = Colour.of(Color.MAGENTA);
    public static final Colour CYAN = Colour.of(Color.CYAN);
    public static final Colour BLUE = Colour.of(Color.BLUE);
    private Color color;
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public Colour(int red, int green, int blue, int alpha) {
        this.red = this.ensureCorrect("Red", red);
        this.green = this.ensureCorrect("Green", green);
        this.blue = this.ensureCorrect("Blue", blue);
        this.alpha = this.ensureCorrect("Alpha", alpha);
        this.color = new Color(red, green, blue, alpha);
    }

    public Colour(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public Colour(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public Colour copy() {
        return new Colour(this.color);
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = this.update(this.ensureCorrect("Red", red), red, this.green, this.blue, this.alpha);
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = this.update(this.ensureCorrect("Green", green), this.red, green, this.blue, this.alpha);
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = this.update(this.ensureCorrect("Blue", blue), this.red, this.green, blue, this.alpha);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = this.update(this.ensureCorrect("Alpha", alpha), this.red, this.green, this.blue, alpha);
    }

    public int getRGB() {
        return this.color.getRGB();
    }

    public Color asColor() {
        return this.color;
    }

    private int ensureCorrect(String name, int value) {
        if (value > 255) {
            throw new IllegalArgumentException(name + " cannot be more than 255.");
        }
        return value;
    }

    private int update(int value, int red, int green, int blue, int alpha) {
        this.color = new Color(red, green, blue, alpha);
        return value;
    }

    public static Colour of(int red, int green, int blue, int alpha) {
        return new Colour(red, green, blue, alpha);
    }

    public static Colour of(int red, int green, int blue) {
        return new Colour(red, green, blue);
    }

    public static Colour of(Color color) {
        return new Colour(color);
    }

    public static Colour of(Vec3 color) {
        return new Colour(color.getX(), color.getY(), color.getZ());
    }

    public static Colour randomColour() {
        return Colour.of(Numbers.randomiseVec3(255, 0));
    }

    public String toString() {
        return "(" + this.red + ", " + this.green + ", " + this.blue + ", " + this.alpha + ")";
    }
}

