/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils.collections.abstraction;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import xyz.deftu.deftils.Maps;
import xyz.deftu.deftils.annotations.Beta;
import xyz.deftu.deftils.collections.MultiMap;

@Beta
public abstract class AbstractMultiMap<K, V>
implements MultiMap<K, V> {
    protected final Map<K, List<V>> map = Maps.newHashMap();
    protected final Class<?> listType;

    public AbstractMultiMap(Class<?> listType) {
        this.listType = listType;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        AtomicBoolean contained = new AtomicBoolean(false);
        this.map.forEach((? super K key, ? super V val) -> {
            for (Object v : val) {
                contained.set(v.equals(value));
            }
        });
        return contained.get();
    }

    @Override
    public void put(K key, V value) {
        try {
            this.map.putIfAbsent(key, (List)this.listType.newInstance());
            this.map.get(key).add(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Collection<Map.Entry<K, List<V>>> entries() {
        return this.map.entrySet();
    }

    @Override
    public List<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Map<K, List<V>> asMap() {
        return this.map;
    }

    public String toString() {
        return this.map.toString();
    }
}

