/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils.collections;

import java.util.AbstractMap;
import java.util.Map;
import xyz.deftu.deftils.collections.impl.ImmutablePair;
import xyz.deftu.deftils.collections.impl.MutablePair;

public interface Pair<L, R> {
    default public boolean isMutable() {
        return this instanceof MutablePair;
    }

    default public boolean isImmutable() {
        return !this.isMutable();
    }

    public L left();

    public R right();

    default public void left(L left) {
        throw new UnsupportedOperationException("Attempt to modify an immutable pair!");
    }

    default public void right(R right) {
        throw new UnsupportedOperationException("Attempt to modify an immutable pair!");
    }

    default public L first() {
        return this.left();
    }

    default public R second() {
        return this.right();
    }

    default public void first(L first) {
        this.left(first);
    }

    default public void second(R second) {
        this.right(second);
    }

    default public L key() {
        return this.left();
    }

    default public R value() {
        return this.right();
    }

    default public void key(L key) {
        this.left(key);
    }

    default public void value(R value) {
        this.right(value);
    }

    default public Map.Entry<L, R> asEntry() {
        return this.isMutable() ? new AbstractMap.SimpleEntry<L, R>(this.left(), this.right()) : new AbstractMap.SimpleImmutableEntry<L, R>(this.left(), this.right());
    }

    public static <L, R> Pair<L, R> empty(boolean immutable) {
        return immutable ? new ImmutablePair<Object, Object>(null, null) : new MutablePair();
    }

    public static <L, R> Pair<L, R> empty() {
        return Pair.empty(false);
    }

    public static <L, R> Pair<L, R> of(boolean immutable, L left, R right) {
        return immutable ? new ImmutablePair<L, R>(left, right) : new MutablePair<L, R>(left, right);
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return Pair.of(false, left, right);
    }
}

