/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import xyz.deftu.deftils.Objects;
import xyz.deftu.deftils.annotations.Unfinished;

public class Strings {
    private static final List<String> questions = Arrays.asList("what", "why", "when", "who", "where", "how");

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean containsIgnoreCase(String input, String check) {
        Objects.ensureNotNull(input, "Input");
        Objects.ensureNotNull(check, "Check");
        if (check.isEmpty()) {
            return true;
        }
        int length = check.length();
        for (int i = input.length() - length; i >= 0; --i) {
            if (!input.regionMatches(true, i, check, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String listGrammatically(List<String> input) {
        StringBuilder replacement = new StringBuilder();
        for (String in : input) {
            boolean last;
            int index = input.indexOf(in);
            boolean first = index == 0;
            boolean bl = last = index == input.size() - 1;
            if (!first && !last) {
                replacement.append(", ");
            }
            if (!first && last) {
                replacement.append(" and ");
            }
            replacement.append(in);
        }
        return replacement.toString();
    }

    public static String listGrammatically(String ... input) {
        return Strings.listGrammatically(Arrays.asList(input));
    }

    public static String prepend(String prefix, String string) {
        return prefix + string;
    }

    public static String capitalize(String input) {
        return Character.toString(input.charAt(0)).toUpperCase() + input.substring(1);
    }

    @Unfinished
    public static String punctuate(String input) {
        String mark = ".";
        if (input.contains(" ") && questions.contains(input.substring(0, input.indexOf(" ")).toLowerCase())) {
            mark = "?";
        }
        if (!input.endsWith(mark)) {
            input = input + mark;
        }
        return input;
    }

    public static String getLongestString(Object[] strings) {
        String longestString = "";
        int longest = 0;
        for (Object o : strings) {
            String string = Objects.stringify(o);
            if (string.length() <= longest) continue;
            longestString = string;
            longest = string.length();
        }
        return longestString;
    }

    public static int getLongestStringWidth(Object[] strings) {
        return Strings.getLongestString(strings).length();
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    private static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.stringify(first);
        }
        StringBuilder buf = new StringBuilder();
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static List<String> getQuestions() {
        return questions;
    }
}

