/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils;

import java.util.Random;
import xyz.deftu.deftils.collections.impl.MutablePair;
import xyz.deftu.deftils.collections.impl.MutableTriplet;
import xyz.deftu.deftils.data.Vec2;
import xyz.deftu.deftils.data.Vec3;

public class Numbers {
    private static final Random random = new Random();

    public static double getDistanceBetween(Vec3 first, Vec3 second, boolean onlyHorizontal) {
        int distanceX = first.getX() - second.getX();
        int distanceZ = first.getZ() - second.getZ();
        int distance = distanceX * distanceX + distanceZ * distanceZ;
        if (!onlyHorizontal) {
            int distanceY = first.getY() - second.getY();
            distance += distanceY * distanceY;
        }
        return Math.sqrt(distance);
    }

    public static double getDistanceBetween(Vec3 first, Vec3 second) {
        return Numbers.getDistanceBetween(first, second, false);
    }

    public static double getDistanceBetween(Vec3 first, Vec2 second, int zPlane) {
        return Numbers.getDistanceBetween(first, new Vec3(second.getX(), second.getY(), zPlane), false);
    }

    public static int dotProduct(Vec3 first, Vec3 second) {
        return first.getX() * second.getX() + first.getY() * second.getY() + first.getZ() * second.getZ();
    }

    public static int dotProduct(Vec2 first, Vec2 second) {
        return first.getX() * second.getX() + first.getY() * second.getY();
    }

    public static Vec3 crossProduct(Vec3 first, Vec3 second) {
        int cx = first.getY() * second.getZ() - first.getZ() * second.getY();
        int cy = first.getZ() * second.getX() - first.getX() * second.getZ();
        int cz = first.getX() * second.getY() - first.getY() * second.getX();
        return new Vec3(cx, cy, cz);
    }

    public static MutableTriplet<Float, Float, Float> normaliseVec3(Vec3 x) {
        float xn = Numbers.normaliseInteger(x.getX());
        float yn = Numbers.normaliseInteger(x.getY());
        float zn = Numbers.normaliseInteger(x.getZ());
        return new MutableTriplet<Float, Float, Float>(Float.valueOf(xn), Float.valueOf(yn), Float.valueOf(zn));
    }

    public static MutablePair<Float, Float> normaliseVec2(Vec2 x) {
        float xn = Numbers.normaliseInteger(x.getX());
        float yn = Numbers.normaliseInteger(x.getY());
        return new MutablePair<Float, Float>(Float.valueOf(xn), Float.valueOf(yn));
    }

    public static float normaliseInteger(int x) {
        return (float)Math.max((double)((float)x / 2.1474836E9f), -1.0);
    }

    public static Vec3 randomiseVec3(int max, int min) {
        return new Vec3(Numbers.getRandomInteger(max, min), Numbers.getRandomInteger(max, min), Numbers.getRandomInteger(max, min));
    }

    public static Vec2 randomiseVec2(int max, int min) {
        return new Vec2(Numbers.getRandomInteger(max, min), Numbers.getRandomInteger(max, min));
    }

    public static int getRandomInteger() {
        return random.nextInt();
    }

    public static int getRandomInteger(int max, int min) {
        return random.nextInt(max - min) + min;
    }

    public static float getRandomFloat() {
        return random.nextFloat();
    }

    public static float getRandomFloat(float max, float min) {
        return min + random.nextFloat() * (max - min);
    }

    public static double getRandomDouble() {
        return random.nextDouble();
    }

    public static double getRandomDouble(double max, double min) {
        return min + random.nextDouble() * (max - min);
    }

    public static long getRandomLong() {
        return random.nextLong();
    }

    public static long getRandomLong(long max, long min) {
        return min + random.nextLong() * (max - min);
    }

    public static boolean isPositive(int number) {
        return number >= 0;
    }

    public static boolean isPositive(float number) {
        return number >= 0.0f;
    }

    public static boolean isPositive(double number) {
        return number >= 0.0;
    }

    public static boolean isPositive(long number) {
        return number >= 0L;
    }

    public static boolean isNegative(int number) {
        return number < 0;
    }

    public static boolean isNegative(float number) {
        return number < 0.0f;
    }

    public static boolean isNegative(double number) {
        return number < 0.0;
    }

    public static boolean isNegative(long number) {
        return number < 0L;
    }

    public static Random getRandom() {
        return random;
    }
}

