/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils;

import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Multithreading {
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, String.format("Deftils Thread %s", threadCount.getAndIncrement())));
    private static final ScheduledExecutorService runnableExecutor = new ScheduledThreadPoolExecutor(6);

    public static void runAsync(Runnable runnable) {
        executor.execute(runnable);
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        return runnableExecutor.schedule(runnable, delay, timeUnit);
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, long startDelay, long delay, TimeUnit timeUnit) {
        return runnableExecutor.scheduleAtFixedRate(runnable, startDelay, delay, timeUnit);
    }

    public static Future<?> submit(Runnable runnable) {
        return executor.submit(runnable);
    }

    public static ThreadPoolExecutor getExecutor() {
        return executor;
    }

    public static ScheduledExecutorService getRunnableExecutor() {
        return runnableExecutor;
    }
}

