/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Lists {
    public static <T> ArrayList<T> newArrayList(List<T> parent) {
        return new ArrayList<T>(parent);
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        return Lists.newArrayList(Arrays.asList(elements));
    }

    public static <T> ArrayList<T> newArrayList() {
        return Lists.newArrayList(new ArrayList());
    }

    public static <T> LinkedList<T> newLinkedList(List<T> parent) {
        return new LinkedList<T>(parent);
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        return Lists.newLinkedList(Arrays.asList(elements));
    }

    public static <T> LinkedList<T> newLinkedList() {
        return Lists.newLinkedList(new LinkedList());
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(List<T> parent) {
        return new CopyOnWriteArrayList<T>(parent);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(T ... elements) {
        return Lists.newCopyOnWriteArrayList(Arrays.asList(elements));
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList() {
        return Lists.newCopyOnWriteArrayList(new CopyOnWriteArrayList());
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        Collection<Object> collection = Lists.toCollection(iterable);
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> Collection<T> toCollection(Iterable<T> iterable) {
        return iterable instanceof Collection ? (Collection)iterable : null;
    }
}

