/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.deftils;

import java.awt.Color;
import xyz.deftu.deftils.collections.abstraction.AbstractTriplet;
import xyz.deftu.deftils.collections.impl.MutableTriplet;

public class Colours {
    public static int alphaOf(int colour) {
        return colour >> 24 & 0xFF;
    }

    public static String toHex(int colour) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(colour & 0xFFFFFF));
        while (hex.length() < 6) {
            hex.insert(0, "0");
        }
        return hex.toString();
    }

    public static String toHex(Color colour) {
        return Colours.toHex(colour.getRGB());
    }

    public static MutableTriplet<Double, Double, Double> convertRgbToNormalised(int r, int g, int b) {
        double red = (double)r / 255.0;
        double green = (double)g / 255.0;
        double blue = (double)b / 255.0;
        return new MutableTriplet<Double, Double, Double>(red, green, blue);
    }

    public static MutableTriplet<Double, Double, Double> convertRgbToNormalised(AbstractTriplet<Integer, Integer, Integer> rgb) {
        return Colours.convertRgbToNormalised((Integer)rgb.first(), (Integer)rgb.second(), (Integer)rgb.third());
    }
}

