/*
 * Decompiled with CFR 0.152.
 */
package xyz.cssxsh.arknights.prts;

import io.ktor.http.ContentType;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.cssxsh.arknights.CacheKey;
import xyz.cssxsh.arknights.excel.Character;
import xyz.cssxsh.arknights.excel.CharacterVoiceInfo;
import xyz.cssxsh.arknights.excel.CharacterWord;
import xyz.cssxsh.arknights.excel.VoiceLanguageType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0001\f\u00a8\u0006\r"}, d2={"Lxyz/cssxsh/arknights/prts/StaticData;", "Lxyz/cssxsh/arknights/CacheKey;", "()V", "character", "", "getCharacter", "()Ljava/lang/String;", "type", "Lio/ktor/http/ContentType;", "getType", "()Lio/ktor/http/ContentType;", "Voice", "Lxyz/cssxsh/arknights/prts/StaticData$Voice;", "arknights-helper"})
public abstract class StaticData
implements CacheKey {
    private StaticData() {
    }

    @NotNull
    public abstract String getCharacter();

    @NotNull
    public abstract ContentType getType();

    public /* synthetic */ StaticData(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0002\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lxyz/cssxsh/arknights/prts/StaticData$Voice;", "Lxyz/cssxsh/arknights/prts/StaticData;", "character", "Lxyz/cssxsh/arknights/excel/Character;", "word", "Lxyz/cssxsh/arknights/excel/CharacterWord;", "voice", "Lxyz/cssxsh/arknights/excel/CharacterVoiceInfo;", "(Lxyz/cssxsh/arknights/excel/Character;Lxyz/cssxsh/arknights/excel/CharacterWord;Lxyz/cssxsh/arknights/excel/CharacterVoiceInfo;)V", "", "getCharacter", "()Ljava/lang/String;", "filename", "getFilename", "group", "getGroup", "type", "Lio/ktor/http/ContentType;", "getType", "()Lio/ktor/http/ContentType;", "url", "getUrl", "arknights-helper"})
    public static final class Voice
    extends StaticData {
        @NotNull
        private final String character;
        @NotNull
        private final String filename;
        @NotNull
        private final ContentType type;
        @NotNull
        private final String group;
        @NotNull
        private final String url;

        public Voice(@NotNull Character character2, @NotNull CharacterWord word2, @NotNull CharacterVoiceInfo voice2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)character2, (String)"character");
            Intrinsics.checkNotNullParameter((Object)word2, (String)"word");
            Intrinsics.checkNotNullParameter((Object)voice2, (String)"voice");
            super(null);
            this.character = word2.getCharacter();
            this.filename = character2.getName() + "/" + word2.getVoiceId() + "_" + word2.getVoiceTitle() + "_" + voice2.getLanguage() + ".wav";
            this.type = new ContentType("audio", "wav", null, 4, null);
            switch (WhenMappings.$EnumSwitchMapping$0[voice2.getLanguage().ordinal()]) {
                case 1: {
                    string = "voice";
                    break;
                }
                case 2: {
                    string = "voice_cn";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "voice_custom";
                    break;
                }
                case 7: {
                    string = "voice_en";
                    break;
                }
                case 8: {
                    string = "voice_kr";
                    break;
                }
                case 9: {
                    String string2 = voice2.getPath();
                    if (string2 == null) {
                        string2 = "voice";
                    }
                    String string3 = StringsKt.substringAfterLast$default((String)StringsKt.removeSuffix((String)string2, (CharSequence)"/"), (String)"/", null, (int)2, null).toLowerCase(Locale.ROOT);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.group = string;
            String string4 = StringsKt.replace$default((String)voice2.getWordKey(), (String)"#", (String)"_", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.url = "https://static.prts.wiki/" + this.group + "/" + string4 + "/" + word2.getVoiceId() + ".wav";
        }

        @Override
        @NotNull
        public String getCharacter() {
            return this.character;
        }

        @Override
        @NotNull
        public String getFilename() {
            return this.filename;
        }

        @Override
        @NotNull
        public ContentType getType() {
            return this.type;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VoiceLanguageType.values().length];
                try {
                    nArray[VoiceLanguageType.JP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.CN_MANDARIN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.CN_TOPOLECT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.ITA.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.RUS.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.GER.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.EN.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.KR.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VoiceLanguageType.LINKAGE.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

