/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.MapResultError;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Tok;

public class TokensIterator<P extends Pointer<?, ?, P>, T extends Tok<P>>
implements Iterator<T> {
    private final List<GR> rules;
    private P pointer;
    private T fetched;

    public TokensIterator(P initial, List<GR<P, T>> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("rules==null");
        }
        if (initial == null) {
            throw new IllegalArgumentException("initial==null");
        }
        ArrayList<GR<P, T>> arules = new ArrayList<GR<P, T>>();
        for (GR<P, T> r : rules) {
            if (r == null) {
                throw new IllegalArgumentException("rules contains empty element");
            }
            arules.add(r);
        }
        this.rules = Collections.unmodifiableList(arules);
        this.pointer = initial;
        this.fetched = this.fetch(this.pointer);
        if (this.fetched != null) {
            this.pointer = this.fetched.end();
        }
    }

    public P pointer() {
        return this.pointer;
    }

    private T fetch(P pointer) {
        if (pointer == null) {
            return null;
        }
        if (pointer.eof()) {
            return null;
        }
        for (GR r : this.rules) {
            Optional ot = (Optional)r.apply(pointer);
            if (ot == null) {
                throw new MapResultError("return null");
            }
            if (!ot.isPresent()) continue;
            if (ot.get() == null) {
                throw new MapResultError("return null");
            }
            return (T)((Tok)ot.get());
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.fetched != null;
    }

    @Override
    public T next() {
        T r = this.fetched;
        this.fetched = this.fetch(this.pointer);
        if (this.fetched != null) {
            this.pointer = this.fetched.end();
        }
        return r;
    }
}

