/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import xyz.cofe.text.tparse.CToken;
import xyz.cofe.text.tparse.CharPointer;
import xyz.cofe.text.tparse.GR;

public class Chars {
    public static final GR<CharPointer, CToken> digit = Chars.test(Character::isDigit);
    public static final GR<CharPointer, CToken> letter = Chars.test(Character::isLetter);
    public static final GR<CharPointer, CToken> letterOrDigit = Chars.test(Character::isLetterOrDigit);
    public static final GR<CharPointer, CToken> whitespace = Chars.test(Character::isWhitespace);

    public static GR<CharPointer, CToken> test(final Predicate<Character> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        return new GR<CharPointer, CToken>(){
            private String name;

            @Override
            public GR<CharPointer, CToken> name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                if (this.name != null) {
                    return this.name;
                }
                return super.toString();
            }

            @Override
            public Optional<CToken> apply(CharPointer ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                Optional<Character> chr = ptr.lookup(0);
                if (chr == null) {
                    return Optional.empty();
                }
                if (!chr.isPresent()) {
                    return Optional.empty();
                }
                if (!filter.test(chr.get())) {
                    return Optional.empty();
                }
                return Optional.of(new CToken(ptr, ptr.move(1)));
            }
        };
    }

    public static <U extends CToken> GR<CharPointer, U> test(final Predicate<Character> filter, final Function<CharPointer, U> map) {
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        if (map == null) {
            throw new IllegalArgumentException("map==null");
        }
        return new GR<CharPointer, U>(){
            private String name;

            @Override
            public GR<CharPointer, U> name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                if (this.name != null) {
                    return this.name;
                }
                return super.toString();
            }

            @Override
            public Optional<U> apply(CharPointer ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                Optional<Character> chr = ptr.lookup(0);
                if (chr == null) {
                    return Optional.empty();
                }
                if (!chr.isPresent()) {
                    return Optional.empty();
                }
                if (!filter.test(chr.get())) {
                    return Optional.empty();
                }
                return Optional.of((CToken)map.apply(ptr));
            }
        };
    }
}

