/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.List;
import java.util.Optional;
import xyz.cofe.text.tparse.Pointer;

public class LPointer<T>
implements Pointer<T, Integer, LPointer<T>> {
    private final List<T> tokens;
    private int position;

    public LPointer(List<T> tokens, int pos) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens==null");
        }
        this.position = pos;
        this.tokens = tokens;
    }

    public LPointer(List<T> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens==null");
        }
        this.position = 0;
        this.tokens = tokens;
    }

    protected LPointer(LPointer<T> sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample == null");
        }
        this.position = sample.position;
        this.tokens = sample.tokens;
    }

    public LPointer<T> clone() {
        return new LPointer<T>(this);
    }

    public List<T> tokens() {
        return this.tokens;
    }

    @Override
    public boolean eof() {
        if (this.position < 0) {
            return true;
        }
        return this.position >= this.tokens.size();
    }

    @Override
    public Integer position() {
        return this.position;
    }

    @Override
    public LPointer<T> move(Integer offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset==null");
        }
        Object c = this.clone();
        ((LPointer)c).position += offset.intValue();
        return c;
    }

    @Override
    public Optional<T> lookup(Integer offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset==null");
        }
        int t = this.position + offset;
        if (t < 0 || t >= this.tokens.size()) {
            return Optional.empty();
        }
        return Optional.of(this.tokens.get(t));
    }

    @Override
    public int compareTo(LPointer<T> o) {
        if (o == null) {
            return 0;
        }
        if (o == this) {
            return 0;
        }
        if (o.tokens != this.tokens) {
            return 0;
        }
        return Integer.compare(this.position, o.position);
    }

    public String toString() {
        return LPointer.class.getSimpleName() + " " + this.position();
    }
}

