/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.function.BiFunction;
import java.util.function.Function;
import xyz.cofe.fn.Fn3;
import xyz.cofe.text.parse.Pointer;
import xyz.cofe.text.parse.Tok;

public class Alternatives<P extends Pointer, T extends Tok<P>>
implements Function<P, T> {
    private final Function<P, T>[] expressions;
    private Fn3<P, P, ? super T, ? extends T> builder;

    public Function<P, T>[] getExpressions() {
        return this.expressions;
    }

    public Alternatives(Function<P, T>[] expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        this.expressions = expressions;
    }

    public Alternatives(Alternatives<P, T> sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.expressions = sample.expressions;
        this.builder = sample.builder;
    }

    public Alternatives<P, T> clone() {
        return new Alternatives<P, T>(this);
    }

    @Override
    public T apply(P tp) {
        if (tp == null) {
            throw new IllegalArgumentException("tp==null");
        }
        if (tp.eof()) {
            return null;
        }
        P begin = tp;
        for (Function<P, P> function : this.expressions) {
            Tok t;
            if (function == null || (t = (Tok)function.apply(tp)) == null) continue;
            Object nptr = t.getEnd();
            if (tp.compareTo(nptr) >= 0) {
                throw new Error("parser return empty token");
            }
            return (T)this.build(begin, nptr, t);
        }
        return null;
    }

    public <R extends T> Alternatives<P, R> build(BiFunction<P, P, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        Alternatives<P, T> seq = new Alternatives<P, T>(this.expressions);
        seq.builder = (b, e, l) -> (Tok)fn.apply(b, e);
        return seq;
    }

    public <R extends T> Alternatives<P, R> build(Fn3<P, P, T, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        Alternatives<P, T> seq = new Alternatives<P, T>(this.expressions);
        seq.builder = fn;
        return seq;
    }

    public Fn3<P, P, ? super T, ? extends T> getBuilder() {
        return this.builder;
    }

    private T build(P begin, P end, T token) {
        if (this.builder != null) {
            return (T)((Tok)this.builder.apply(begin, end, token));
        }
        return token;
    }
}

