/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import xyz.cofe.text.Text;

public class XEventPath
extends Stack<XMLEvent> {
    private static final Logger logger = Logger.getLogger(XEventPath.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(XEventPath.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(XEventPath.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(XEventPath.class.getName(), method, result);
    }

    public String getName() {
        StartElement e = this.getLastElement();
        if (e == null) {
            return null;
        }
        return e.getName().getLocalPart();
    }

    public boolean hasAttribute(String attrName) {
        return this.getAttributeValue(attrName) != null;
    }

    public boolean hasAttribute(String attrName, boolean ignoreCase) {
        return this.getAttributeValue(attrName, ignoreCase) != null;
    }

    @Override
    public XEventPath clone() {
        XEventPath res = new XEventPath();
        res.addAll(this);
        return res;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            XMLEvent e = (XMLEvent)this.get(i);
            if (e instanceof StartElement) {
                sb.append("/");
                StartElement se = (StartElement)e;
                sb.append(se.getName().getLocalPart());
                int j = -1;
                Iterator<Attribute> iAttrs = se.getAttributes();
                while (iAttrs.hasNext()) {
                    Attribute oa = iAttrs.next();
                    if (oa == null || !(oa instanceof Attribute)) continue;
                    Attribute attr = oa;
                    if (++j == 0) {
                        sb.append("[");
                    }
                    sb.append(attr.getName());
                    sb.append("=");
                    sb.append(Text.encodeStringConstant((String)attr.getValue()));
                }
                if (j < 0) continue;
                sb.append("]");
                continue;
            }
            if (!(e instanceof StartDocument)) continue;
            sb.append("#DOC");
        }
        return sb.toString();
    }

    public StartElement getLastElement() {
        if (this.size() < 1) {
            return null;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            Object o = this.get(i);
            if (!(o instanceof StartElement)) continue;
            return (StartElement)o;
        }
        return null;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, false);
    }

    public String readAttributeAsString(String attributeName, String defaultValue) {
        String str = this.getAttributeValue(attributeName);
        return str == null ? defaultValue : str;
    }

    public Boolean readAttributeAsBoolean(String attributeName, Boolean defaultValue) {
        String str = this.getAttributeValue(attributeName);
        if (str == null) {
            return defaultValue;
        }
        if (Text.in((String)str.toLowerCase().trim(), (String[])new String[]{"true", "1", "on", "yes"})) {
            return true;
        }
        if (Text.in((String)str.toLowerCase().trim(), (String[])new String[]{"false", "0", "off", "no"})) {
            return false;
        }
        XEventPath.logWarning("unparsed xml attribute {0} = {1} as {3}", attributeName, str, "boolean");
        return defaultValue;
    }

    public Integer readAttributeAsInteger(String attributeName, Integer defaultValue) {
        String str = this.getAttributeValue(attributeName);
        if (str == null) {
            return defaultValue;
        }
        try {
            Integer v = Integer.parseInt(str);
            return v;
        }
        catch (NumberFormatException ex) {
            XEventPath.logWarning("unparsed xml attribute {0} = {1} as {3} - error {4}", attributeName, str, "Integer", ex.getLocalizedMessage());
            return defaultValue;
        }
    }

    public Long readAttributeAsLong(String attributeName, Long defaultValue) {
        String str = this.getAttributeValue(attributeName);
        if (str == null) {
            return defaultValue;
        }
        try {
            Long v = Long.parseLong(str);
            return v;
        }
        catch (NumberFormatException ex) {
            XEventPath.logWarning("unparsed xml attribute {0} = {1} as {3} - error {4}", attributeName, str, "Long", ex.getLocalizedMessage());
            return defaultValue;
        }
    }

    public Double readAttributeAsDouble(String attributeName, Double defaultValue) {
        String str = this.getAttributeValue(attributeName);
        if (str == null) {
            return defaultValue;
        }
        try {
            Double v = Double.parseDouble(str);
            return v;
        }
        catch (NumberFormatException ex) {
            XEventPath.logWarning("unparsed xml attribute {0} = {1} as {3} - error {4}", attributeName, str, "Double", ex.getLocalizedMessage());
            return defaultValue;
        }
    }

    public String getAttributeValue(String name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        StartElement e = this.getLastElement();
        if (e == null) {
            return null;
        }
        Iterator<Attribute> itrAttr = e.getAttributes();
        while (itrAttr.hasNext()) {
            Attribute o = itrAttr.next();
            if (!(o instanceof Attribute)) continue;
            Attribute a = o;
            String n = a.getName().getLocalPart();
            if (!(ignoreCase ? n.equalsIgnoreCase(name) : n.equals(name))) continue;
            return a.getValue();
        }
        return null;
    }

    public XEventPath dropLastElement() {
        if (this.size() < 1) {
            return new XEventPath();
        }
        int lastEl = -1;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object o = this.get(i);
            if (!(o instanceof StartElement)) continue;
            lastEl = i;
            break;
        }
        if (lastEl <= 0) {
            return new XEventPath();
        }
        XEventPath path = new XEventPath();
        for (int i = 0; i < lastEl; ++i) {
            path.add(this.get(i));
        }
        return path;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

