/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import xyz.cofe.collection.Predicate;
import xyz.cofe.xml.stream.path.PathExpression;
import xyz.cofe.xml.stream.path.XEventPath;

public class TagMatcher
implements PathExpression {
    protected Predicate<XMLEvent> elementPredicate = null;

    public TagMatcher() {
    }

    public TagMatcher(Predicate<XMLEvent> xmlElementPred) {
        this.setElementPredicate(xmlElementPred);
    }

    public Predicate<XMLEvent> getElementPredicate() {
        return this.elementPredicate;
    }

    public void setElementPredicate(Predicate<XMLEvent> elementPredicate) {
        this.elementPredicate = elementPredicate;
    }

    public boolean validate(XEventPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        if (this.elementPredicate == null) {
            return true;
        }
        if (path.size() < 1) {
            return false;
        }
        StartElement se = path.getLastElement();
        if (se == null) {
            return false;
        }
        return this.elementPredicate.validate((Object)se);
    }

    public static Predicate<XMLEvent> hasAttribute(final String name, final boolean ignoreCase) {
        return new Predicate<XMLEvent>(){

            public boolean validate(XMLEvent value) {
                if (!(value instanceof StartElement)) {
                    return false;
                }
                StartElement se = (StartElement)value;
                if (name == null) {
                    return false;
                }
                if (value == null) {
                    return false;
                }
                Iterator<Attribute> itrAttr = se.getAttributes();
                while (itrAttr.hasNext()) {
                    Attribute o = itrAttr.next();
                    if (!(o instanceof Attribute)) continue;
                    Attribute attr = o;
                    String aname = attr.getName().getLocalPart();
                    if (!(ignoreCase ? aname.equalsIgnoreCase(name) : aname.equals(name))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<XMLEvent> attr(Predicate<String> attrNamePredicate, Predicate<String> valuePredicate) {
        final Predicate<String> valuep = valuePredicate;
        final Predicate<String> namep = attrNamePredicate;
        return new Predicate<XMLEvent>(){

            public boolean validate(XMLEvent value) {
                if (namep == null) {
                    return false;
                }
                if (valuep == null) {
                    return false;
                }
                if (!(value instanceof StartElement)) {
                    return false;
                }
                StartElement se = (StartElement)value;
                Iterator<Attribute> itrAttr = se.getAttributes();
                while (itrAttr.hasNext()) {
                    String avalue;
                    Attribute attr;
                    String aname;
                    Attribute o = itrAttr.next();
                    if (!(o instanceof Attribute) || !namep.validate((Object)(aname = (attr = o).getName().getLocalPart())) || !valuep.validate((Object)(avalue = attr.getValue()))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<XMLEvent> nameEquals(String name) {
        final String nm = name;
        return new Predicate<XMLEvent>(){

            public boolean validate(XMLEvent value) {
                if (value == null) {
                    return false;
                }
                if (!(value instanceof StartElement)) {
                    return false;
                }
                StartElement se = (StartElement)value;
                return se.getName().getLocalPart().equals(nm);
            }
        };
    }

    public static Predicate<XMLEvent> nameEqualsIgnoreCase(String name) {
        final String nm = name;
        return new Predicate<XMLEvent>(){

            public boolean validate(XMLEvent value) {
                if (value == null) {
                    return false;
                }
                if (!(value instanceof StartElement)) {
                    return false;
                }
                StartElement se = (StartElement)value;
                return se.getName().getLocalPart().equalsIgnoreCase(nm);
            }
        };
    }

    public static Predicate<XMLEvent> nameMatches(String name) {
        final String nm = name;
        return new Predicate<XMLEvent>(){

            public boolean validate(XMLEvent value) {
                if (value == null) {
                    return false;
                }
                if (!(value instanceof StartElement)) {
                    return false;
                }
                StartElement se = (StartElement)value;
                return se.getName().getLocalPart().matches(nm);
            }
        };
    }
}

