/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import javax.xml.stream.events.XMLEvent;
import xyz.cofe.collection.Predicate;
import xyz.cofe.text.Text;
import xyz.cofe.xml.stream.path.ParentMatcher;
import xyz.cofe.xml.stream.path.PathExpression;
import xyz.cofe.xml.stream.path.TagMatcher;
import xyz.cofe.xml.stream.path.XEventPath;

public class Expressions {
    private static PathExpression rootPath = new PathExpression(){

        public boolean validate(XEventPath value) {
            if (value == null) {
                return false;
            }
            for (XMLEvent e : value) {
                if (e.isStartDocument()) continue;
                return false;
            }
            return true;
        }
    };

    public static PathExpression rootPath() {
        return rootPath;
    }

    public static PathExpression andPath(PathExpression ... expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        final PathExpression[] exp = expressions;
        return new PathExpression(){

            public boolean validate(XEventPath value) {
                for (PathExpression e : exp) {
                    if (e == null || e.validate(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static PathExpression orPath(PathExpression ... expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        final PathExpression[] exp = expressions;
        return new PathExpression(){

            public boolean validate(XEventPath value) {
                for (PathExpression e : exp) {
                    if (e == null || !e.validate(value)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathExpression notPath(PathExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression==null");
        }
        final PathExpression exp = expression;
        return new PathExpression(){

            public boolean validate(XEventPath value) {
                return !exp.validate(value);
            }
        };
    }

    public static PathExpression parentPath(PathExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression==null");
        }
        return new ParentMatcher(expression);
    }

    public static PathExpression hasAttribute(String name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.hasAttribute(name, ignoreCase));
    }

    public static PathExpression hasAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.hasAttribute(name, false));
    }

    public static PathExpression attr(Predicate<String> namePredicate, Predicate<String> valuePredicate) {
        if (namePredicate == null) {
            throw new IllegalArgumentException("namePredicate==null");
        }
        if (valuePredicate == null) {
            throw new IllegalArgumentException("valuePredicate==null");
        }
        return new TagMatcher(TagMatcher.attr(namePredicate, valuePredicate));
    }

    public static PathExpression attrIsNumeric(String attrName) {
        return Expressions.attr((Predicate<String>)Text.Predicates.equals((String)attrName), (Predicate<String>)Text.Predicates.isNumeric());
    }

    public static PathExpression tagNameEquals(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.nameEquals(name));
    }

    public static PathExpression tagNameEqualsIgnoreCase(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.nameEqualsIgnoreCase(name));
    }

    public static PathExpression tagNameMatches(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.nameMatches(name));
    }
}

