/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.list.BasicEventList;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.LockEventList;
import xyz.cofe.collection.list.SyncEventList;
import xyz.cofe.collection.map.BasicEventMap;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.collection.map.SyncEventMap;
import xyz.cofe.collection.set.BasicEventSet;
import xyz.cofe.collection.set.LockEventSet;
import xyz.cofe.collection.set.SyncEventSet;
import xyz.cofe.fs.File;
import xyz.cofe.text.EndLine;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;
import xyz.cofe.types.SimpleTypes;
import xyz.cofe.xml.ElementHelper;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.XMLUtil;
import xyz.cofe.xml.XmlContext;

public class XmlCoder {
    private Map<String, Func1<String, String>> processingInstructions = new LinkedHashMap<String, Func1<String, String>>();
    private Map<String, Class> tag2class = new LinkedHashMap<String, Class>();
    private Map<Class, String> class2tag = new LinkedHashMap<Class, String>();
    private Map<Class, Map<String, PropertyReader>> propertiesReader = new LinkedHashMap<Class, Map<String, PropertyReader>>();
    private Map<Class, Map<String, PropertyWriter>> propertiesWriter = new LinkedHashMap<Class, Map<String, PropertyWriter>>();
    private TypeCastGraph typeCast = null;
    private Map<Class, Map<String, PropertyDescriptor>> properties = new LinkedHashMap<Class, Map<String, PropertyDescriptor>>();
    private Map<Class, Map<String, Integer>> propertiesOrder = new LinkedHashMap<Class, Map<String, Integer>>();
    private Map<String, TagReader> tagReaders = new LinkedHashMap<String, TagReader>();
    private XmlContext xmlContext;
    protected Set<Class> simpleTypes = null;
    protected Set<Class> superSimpleTypes = null;
    private Map<Class, CombinedTypeWriter> classWriters = new LinkedHashMap<Class, CombinedTypeWriter>();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
    }

    public XmlCoder() {
        this.type(BasicEventMap.class).property("wrappedMap").ignore().build();
        this.type(SyncEventMap.class).property("wrappedMap").ignore().build();
        this.type(LockEventMap.class).property("wrappedMap").ignore().build();
        this.type(BasicEventSet.class).property("wrappedSet").ignore().build();
        this.type(SyncEventSet.class).property("wrappedSet").ignore().build();
        this.type(LockEventSet.class).property("wrappedSet").ignore().build();
        this.type(BasicEventList.class).property("wrappedList").ignore().build();
        this.type(IndexEventList.class).property("wrappedList").ignore().build();
        this.type(LockEventList.class).property("wrappedList").ignore().build();
        this.type(SyncEventList.class).property("wrappedList").ignore().build();
    }

    public XmlCoder(XmlCoder src) {
        if (src != null) {
            if (src.processingInstructions != null) {
                this.processingInstructions.putAll(src.processingInstructions);
            }
            if (src.tag2class != null) {
                this.tag2class.putAll(src.tag2class);
            }
            if (src.class2tag != null) {
                this.class2tag.putAll(src.class2tag);
            }
            if (src.propertiesReader != null) {
                this.propertiesReader.putAll(src.propertiesReader);
            }
            if (src.propertiesWriter != null) {
                this.propertiesWriter.putAll(src.propertiesWriter);
            }
            if (src.typeCast != null) {
                this.typeCast = src.typeCast.clone();
            }
            if (src.properties != null) {
                this.properties.putAll(src.properties);
            }
            if (src.tagReaders != null) {
                this.tagReaders.putAll(src.tagReaders);
            }
            if (src.simpleTypes != null) {
                this.getSimpleTypes().addAll(src.simpleTypes);
            }
            if (src.superSimpleTypes != null) {
                this.getSuperSimpleTypes().addAll(src.superSimpleTypes);
            }
            if (src.classWriters != null) {
                this.classWriters.putAll(src.classWriters);
            }
            if (src.xmlContext != null) {
                this.xmlContext = src.xmlContext.clone();
            }
        }
    }

    public XmlCoder clone() {
        return new XmlCoder(this);
    }

    public Map<String, Func1<String, String>> getProcessingInstructions() {
        if (this.processingInstructions != null) {
            return this.processingInstructions;
        }
        this.processingInstructions = new LinkedHashMap<String, Func1<String, String>>();
        return this.processingInstructions;
    }

    public void setProcessingInstructions(Map<String, Func1<String, String>> processingInstruction) {
        this.processingInstructions = processingInstruction;
    }

    public Map<String, Class> getTag2class() {
        if (this.tag2class == null) {
            this.tag2class = new LinkedHashMap<String, Class>();
        }
        return this.tag2class;
    }

    public void setTag2class(Map<String, Class> tag2class) {
        this.tag2class = tag2class;
    }

    public Map<Class, String> getClass2tag() {
        if (this.class2tag == null) {
            this.class2tag = new LinkedHashMap<Class, String>();
        }
        return this.class2tag;
    }

    public void setClass2tag(Map<Class, String> class2tag) {
        this.class2tag = class2tag;
    }

    public Map<Class, Map<String, PropertyReader>> getPropertiesReader() {
        return this.propertiesReader;
    }

    public Map<Class, Map<String, PropertyWriter>> getPropertiesWriter() {
        return this.propertiesWriter;
    }

    public XmlCoder map(String tag, Class cls) {
        if (tag == null) {
            throw new IllegalArgumentException("tag==null");
        }
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        this.getClass2tag().put(cls, tag);
        this.getTag2class().put(tag, cls);
        return this;
    }

    public Attribute property(Class cls, String propertyName) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName==null");
        }
        Attribute a = new Attribute();
        a.cls = cls;
        a.propertyName = propertyName;
        return a;
    }

    public Type type(Class cls) {
        return new Type(cls);
    }

    public TypeCastGraph getTypeCast() {
        if (this.typeCast == null) {
            this.typeCast = new ExtendedCastGraph();
        }
        return this.typeCast;
    }

    public void setTypeCast(TypeCastGraph typeCast) {
        this.typeCast = typeCast;
    }

    protected Class getClassOfTag(String tagName) {
        Class<?> cls = this.getTag2class().get(tagName);
        if (cls != null) {
            return cls;
        }
        String cn = tagName.replace("-", "$");
        try {
            cls = Class.forName(cn);
            return cls;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object createObject(Class cls, Element el) {
        try {
            Constructor ctr = cls.getConstructor(Element.class);
            return ctr.newInstance(el);
        }
        catch (NoSuchMethodException ex) {
            try {
                block17: {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.FINE, null, ex);
                    break block17;
                    catch (SecurityException ex2) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex2);
                        break block17;
                    }
                    catch (InstantiationException ex3) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex3);
                        break block17;
                    }
                    catch (IllegalAccessException ex4) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex4);
                        break block17;
                    }
                    catch (IllegalArgumentException ex5) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex5);
                        break block17;
                    }
                    catch (InvocationTargetException ex6) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex6);
                    }
                }
                ElementHelper eh = new ElementHelper(el);
                if (!eh.hasChildNodes()) return cls.newInstance();
                if (!eh.getElements().isEmpty()) return cls.newInstance();
                String txtContent = eh.getTextContent();
                if (txtContent == null) return cls.newInstance();
                if (txtContent.length() <= 0) return cls.newInstance();
                try {
                    Constructor ctr = cls.getConstructor(String.class);
                    return ctr.newInstance(txtContent);
                }
                catch (NoSuchMethodException ex7) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.FINE, null, ex7);
                    return cls.newInstance();
                }
                catch (SecurityException ex8) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex8);
                    return cls.newInstance();
                }
                catch (InstantiationException ex9) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex9);
                    return cls.newInstance();
                }
                catch (IllegalAccessException ex10) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex10);
                    return cls.newInstance();
                }
                catch (IllegalArgumentException ex11) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex11);
                    return cls.newInstance();
                }
                catch (InvocationTargetException ex12) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex12);
                }
                return cls.newInstance();
            }
            catch (InstantiationException ex13) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex13);
                return null;
            }
            catch (IllegalAccessException ex14) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex14);
            }
        }
        return null;
    }

    private Comparator<String> createPropertyNameOrder(final Class cls) {
        return new Comparator<String>(){

            @Override
            public int compare(String propa, String propb) {
                if (propa == null && propb == null) {
                    return 0;
                }
                if (propa != null && propb == null) {
                    return -1;
                }
                if (propa == null && propb != null) {
                    return 1;
                }
                if (propa != null && propb != null && propa.equals(propb)) {
                    return 0;
                }
                Map propOrdMap = (Map)XmlCoder.this.propertiesOrder.get(cls);
                if (propOrdMap == null) {
                    return propa.compareTo(propb);
                }
                Integer orda = (Integer)propOrdMap.get(propa);
                Integer ordb = (Integer)propOrdMap.get(propb);
                if (orda == null || ordb == null) {
                    return propa.compareTo(propb);
                }
                if (orda == ordb) {
                    return propa.compareTo(propb);
                }
                return orda.compareTo(ordb);
            }
        };
    }

    protected Map<String, PropertyDescriptor> getPropertiesOf(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        Map<String, PropertyDescriptor> props = this.properties.get(cls);
        if (props != null) {
            return props;
        }
        props = new TreeMap<String, PropertyDescriptor>(this.createPropertyNameOrder(cls));
        try {
            PropertyDescriptor[] pds;
            BeanInfo bi = Introspector.getBeanInfo(cls);
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                Ignore ignWrite;
                Method writemeth;
                Ignore ignRead;
                Method readmeth;
                Class<?> type = pd.getPropertyType();
                if (type == null || (readmeth = pd.getReadMethod()) == null || readmeth.getParameterTypes().length > 0 || (ignRead = readmeth.getAnnotation(Ignore.class)) != null || (writemeth = pd.getWriteMethod()) == null || writemeth.getParameterTypes().length > 1 || (ignWrite = writemeth.getAnnotation(Ignore.class)) != null) continue;
                props.put(pd.getName(), pd);
            }
            this.properties.put(cls, props);
            return props;
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    protected boolean restoreProperty(Object propertyOwner, PropertyDescriptor pd, ElementHelper propertyElement) {
        return this.restoreProperty(propertyOwner, pd, propertyElement, null);
    }

    protected boolean restorePropertyFromAttribute(Object propertyOwner, PropertyDescriptor pd, String attributeName, String attributeValue, TypeCastGraph tcg) {
        String txtContent;
        Method writemeth;
        Method method = writemeth = pd != null ? pd.getWriteMethod() : null;
        if (writemeth == null) {
            return false;
        }
        if (writemeth.getParameterTypes().length != 1) {
            return false;
        }
        if (attributeValue == null) {
            return false;
        }
        Class<?> targetParamType = writemeth.getParameterTypes()[0];
        boolean isSimple = this.getSimpleTypes().contains(targetParamType);
        boolean isSuperSimple = false;
        Class superSimpleType = null;
        if (!this.getSuperSimpleTypes().isEmpty()) {
            for (Class supertype : this.getSuperSimpleTypes()) {
                if (!targetParamType.isAssignableFrom(supertype)) continue;
                isSuperSimple = true;
                superSimpleType = supertype;
            }
        }
        if ((isSimple || isSuperSimple) && attributeValue != null) {
            txtContent = attributeValue;
            TypeCastGraph tc = tcg;
            if (tc == null) {
                tc = this.getTypeCast();
            }
            Object targetValue = null;
            try {
                targetValue = isSuperSimple ? tc.cast((Object)txtContent, superSimpleType) : tc.cast((Object)txtContent, targetParamType);
            }
            catch (Throwable cerr) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, cerr);
                return false;
            }
            try {
                writemeth.invoke(propertyOwner, targetValue);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
        if (targetParamType.isEnum()) {
            txtContent = attributeValue;
            Object targetValue = null;
            try {
                targetValue = Enum.valueOf(targetParamType, txtContent);
            }
            catch (Throwable cerr) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, cerr);
                return false;
            }
            try {
                writemeth.invoke(propertyOwner, targetValue);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean restoreProperty(Object propertyOwner, PropertyDescriptor pd, ElementHelper propertyElement, TypeCastGraph tcg) {
        String txtContent;
        Method writemeth = pd.getWriteMethod();
        if (writemeth == null) {
            return false;
        }
        if (writemeth.getParameterTypes().length != 1) {
            return false;
        }
        Class<String> targetParamType = writemeth.getParameterTypes()[0];
        XmlCoder.logFiner("restoreProperty targetParamType={0} property={1} tag={2}", targetParamType, pd.getName(), propertyElement.getTagName());
        List<ElementHelper> childrenEls = propertyElement.getElements();
        boolean isSimple = this.getSimpleTypes().contains(targetParamType);
        boolean isSuperSimple = false;
        Class superSimpleType = null;
        if (!this.getSuperSimpleTypes().isEmpty() && !targetParamType.equals(Object.class)) {
            for (Class supertype : this.getSuperSimpleTypes()) {
                if (!targetParamType.isAssignableFrom(supertype)) continue;
                isSuperSimple = true;
                superSimpleType = supertype;
            }
        }
        if (isSimple || isSuperSimple) {
            txtContent = propertyElement.getTextContent();
            XmlCoder.logFiner("restoreProperty  simple/superSimple tag={3} owner={0} property={1} txt={2}", propertyOwner, pd.getName(), txtContent, propertyElement.getTagName());
            TypeCastGraph tc = tcg;
            if (tc == null) {
                tc = this.getTypeCast();
            }
            Object targetValue = null;
            try {
                targetValue = isSuperSimple ? tc.cast((Object)txtContent, superSimpleType) : tc.cast((Object)txtContent, targetParamType);
            }
            catch (Throwable cerr) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, cerr);
                return false;
            }
            try {
                writemeth.invoke(propertyOwner, targetValue);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
        if (targetParamType.isEnum()) {
            txtContent = propertyElement.getTextContent();
            Object targetValue = null;
            try {
                targetValue = Enum.valueOf(targetParamType, txtContent);
            }
            catch (Throwable cerr) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, cerr);
                return false;
            }
            try {
                writemeth.invoke(propertyOwner, targetValue);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
        if (targetParamType.isAssignableFrom(String.class) && propertyElement.hasChildNodes() && childrenEls.isEmpty()) {
            txtContent = propertyElement.getTextContent();
            try {
                writemeth.invoke(propertyOwner, txtContent);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
        if (childrenEls.isEmpty()) {
            return false;
        }
        ElementHelper firstChild = childrenEls.get(0);
        Object child = this.readXml(firstChild);
        if (child != null && targetParamType.isAssignableFrom(child.getClass())) {
            try {
                writemeth.invoke(propertyOwner, child);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<Element> restoreProperties(Object obj, Class objCls, Element objElement) {
        return this.restoreProperties(obj, objCls, objElement, null);
    }

    protected List<Element> restoreProperties(Object obj, Class objCls, Element objElement, TypeCastGraph tcg) {
        ArrayList<Element> restoredProps = new ArrayList<Element>();
        Map<String, PropertyDescriptor> props = this.getPropertiesOf(objCls);
        if (props == null) {
            return restoredProps;
        }
        if (props.isEmpty()) {
            return restoredProps;
        }
        ArrayList<String> restoredAttr = new ArrayList<String>();
        ArrayList<String> restoredPropeties = new ArrayList<String>();
        Map<String, PropertyReader> proprd = this.propertiesReader.get(objCls);
        NamedNodeMap nnm = objElement.getAttributes();
        if (nnm != null) {
            for (int attrIdx = 0; attrIdx < nnm.getLength(); ++attrIdx) {
                boolean succ;
                boolean succ2;
                PropertyReader pr;
                String attrValue;
                Attr attr;
                String attrName;
                Node n = nnm.item(attrIdx);
                if (!(n instanceof Attr) || (attrName = (attr = (Attr)n).getName()) == null || xyz.cofe.text.Text.in((String)attrName, restoredAttr) || xyz.cofe.text.Text.in((String)attrName, restoredPropeties) || (attrValue = attr.getValue()) == null) continue;
                if (proprd != null && (pr = proprd.get(attrName)) != null && (succ2 = pr.restoreAttribute(obj, props.get(pr.getPropertyName()).getWriteMethod(), attrValue, objElement))) {
                    restoredAttr.add(attrName);
                    restoredPropeties.add(pr.getPropertyName());
                    continue;
                }
                if (attrName == null || attrName.length() <= 0 || attrValue == null || attrValue.length() <= 0 || !(succ = this.restorePropertyFromAttribute(obj, props.get(attrName), attrName, attrValue, tcg))) continue;
                restoredAttr.add(attrName);
                restoredPropeties.add(attrName);
            }
        }
        ElementHelper ehobj = new ElementHelper(objElement);
        for (ElementHelper ehc : ehobj.getElements()) {
            boolean succ;
            PropertyReader pr;
            String ctag = ehc.getTagName();
            PropertyDescriptor pd = props.get(ctag);
            if (pd == null) continue;
            String propn = pd.getName();
            if (xyz.cofe.text.Text.in((String)propn, restoredPropeties)) {
                restoredProps.add(ehc.element);
                continue;
            }
            if (proprd != null && (pr = proprd.get(propn)) != null && (succ = pr.restoreChildTag(obj, pd.getWriteMethod(), ehc.element, objElement))) {
                restoredProps.add(ehc.element);
                restoredPropeties.add(propn);
                continue;
            }
            if (!this.restoreProperty(obj, pd, ehc, tcg)) continue;
            restoredProps.add(ehc.element);
            restoredPropeties.add(propn);
        }
        return restoredProps;
    }

    protected List<Element> restoreListEntries(List list, Element listElement, List<Element> skipElements) {
        ArrayList<Element> restoredlistEls = new ArrayList<Element>();
        ElementHelper eh = new ElementHelper(listElement);
        for (ElementHelper ec : eh.getElements()) {
            boolean skip = false;
            for (Element propel : skipElements) {
                if (ec.element != propel) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            String tn = ec.getTagName();
            if (this.getListEntryTagName().equals(tn)) {
                try {
                    String typename = ec.getAttribute("type");
                    String supertypename = ec.getAttribute("super-type");
                    typename = supertypename != null && supertypename.length() > 0 ? supertypename : typename;
                    Class<?> type = Class.forName(typename);
                    TypeCastGraph tc = this.getTypeCast();
                    String textview = ec.getTextContent();
                    Object v = tc.cast((Object)textview, type);
                    list.add(v);
                    restoredlistEls.add(ec.element);
                }
                catch (Throwable ex) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            Object listEntry = this.readXml(ec.element);
            if (listEntry == null) continue;
            list.add(listEntry);
            restoredlistEls.add(ec.element);
        }
        return restoredlistEls;
    }

    protected List<Element> restoreSetEntries(Set set, Element setElement, List<Element> skipElements) {
        ArrayList<Element> restoredlistEls = new ArrayList<Element>();
        ElementHelper eh = new ElementHelper(setElement);
        for (ElementHelper ec : eh.getElements()) {
            boolean skip = false;
            for (Element propel : skipElements) {
                if (ec.element != propel) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            String tn = ec.getTagName();
            if (this.getSetEntryTagName().equals(tn)) {
                try {
                    String typename = ec.getAttribute("type");
                    String supertypename = ec.getAttribute("super-type");
                    typename = supertypename != null && supertypename.length() > 0 ? supertypename : typename;
                    Class<?> type = Class.forName(typename);
                    TypeCastGraph tc = this.getTypeCast();
                    String textview = ec.getTextContent();
                    Object v = tc.cast((Object)textview, type);
                    set.add(v);
                    restoredlistEls.add(ec.element);
                }
                catch (Throwable ex) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            Object listEntry = this.readXml(ec.element);
            if (listEntry == null) continue;
            set.add(listEntry);
            restoredlistEls.add(ec.element);
        }
        return restoredlistEls;
    }

    protected List<Element> restoreMapEntries(Map map, Element mapElement, List<Element> skipElements) {
        ArrayList<Element> restoredlistEls = new ArrayList<Element>();
        ElementHelper eh = new ElementHelper(mapElement);
        for (ElementHelper ec : eh.getElements()) {
            boolean skip = false;
            for (Element propel : skipElements) {
                if (ec.element != propel) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            String tn = ec.getTagName();
            if (!this.getMapEntryTagName().equals(tn)) continue;
            restoredlistEls.add(ec.element);
            ElementHelper mapenel = ec;
            List<ElementHelper> kvels = mapenel.getElements();
            if (kvels.size() <= 1) continue;
            ElementHelper keyEl = kvels.get(0);
            Object key = null;
            if (!keyEl.hasAttribute("isnull") || !keyEl.getAttribute("isnull").equalsIgnoreCase("true")) {
                TypeCastGraph tc;
                Class<?> keyType;
                String keyTypeName;
                if (keyEl.hasAttribute("super-type")) {
                    keyTypeName = keyEl.getAttribute("super-type");
                    keyType = null;
                    try {
                        keyType = Class.forName(keyTypeName);
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (keyType != null) {
                        tc = this.getTypeCast();
                        key = tc.cast((Object)keyEl.getTextContent(), keyType);
                    }
                } else if (keyEl.hasAttribute("type")) {
                    keyTypeName = keyEl.getAttribute("type");
                    keyType = null;
                    try {
                        keyType = Class.forName(keyTypeName);
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (keyType != null) {
                        tc = this.getTypeCast();
                        key = tc.cast((Object)keyEl.getTextContent(), keyType);
                    }
                } else {
                    key = this.readXml(keyEl);
                }
            }
            ElementHelper valEl = kvels.get(1);
            Object val = null;
            if (!valEl.hasAttribute("isnull") || !valEl.getAttribute("isnull").equalsIgnoreCase("true")) {
                TypeCastGraph tc;
                Class<?> keyType;
                String keyTypeName;
                if (valEl.hasAttribute("super-type")) {
                    keyTypeName = valEl.getAttribute("super-type");
                    keyType = null;
                    try {
                        keyType = Class.forName(keyTypeName);
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (keyType != null) {
                        tc = this.getTypeCast();
                        val = tc.cast((Object)valEl.getTextContent(), keyType);
                    }
                } else if (valEl.hasAttribute("type")) {
                    keyTypeName = valEl.getAttribute("type");
                    keyType = null;
                    try {
                        keyType = Class.forName(keyTypeName);
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (keyType != null) {
                        tc = this.getTypeCast();
                        val = tc.cast((Object)valEl.getTextContent(), keyType);
                    }
                } else {
                    val = this.readXml(valEl);
                }
            }
            map.put(key, val);
        }
        return restoredlistEls;
    }

    public Object readXml(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input==null");
        }
        return this.readXml(new StringReader(input));
    }

    public Object readXml(Reader inputReader) {
        if (inputReader == null) {
            throw new IllegalArgumentException("inputReader==null");
        }
        try {
            return this.readXml(XMLUtil.parseXML(inputReader));
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public Object readXml(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        try {
            InputStream str = url.openStream();
            Object r = this.readXml(str);
            str.close();
            return r;
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public Object readXml(URI url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        try {
            InputStream str = url.toURL().openStream();
            Object r = this.readXml(str);
            str.close();
            return r;
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public Object readXml(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream==null");
        }
        try {
            return this.readXml(XMLUtil.parseXML(inputStream));
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public Object readXml(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        return this.readXml(doc.getDocumentElement());
    }

    public Object readXml(java.io.File file) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("file==null");
            }
            Document doc = XMLUtil.parseXML(file);
            return this.readXml(doc.getDocumentElement());
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public Object readXml(File file) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("file==null");
            }
            Document doc = XMLUtil.parseXML(file);
            return this.readXml(doc.getDocumentElement());
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public Map<String, TagReader> getTagReaders() {
        if (this.tagReaders != null) {
            return this.tagReaders;
        }
        this.tagReaders = new LinkedHashMap<String, TagReader>();
        return this.tagReaders;
    }

    public XmlContext getXmlContext() {
        if (this.xmlContext != null) {
            return this.xmlContext;
        }
        this.xmlContext = new XmlContext();
        return this.xmlContext;
    }

    public void setXmlContext(XmlContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    public Object readXml(Element el) {
        List<Element> r2;
        if (el == null) {
            throw new IllegalArgumentException("el==null");
        }
        if (this.xmlContext != null) {
            Node clone = XMLUtil.cloneXml(el);
            if (!(clone instanceof Element)) {
                throw new Error("failed clone xml");
            }
            el = (Element)clone;
            this.xmlContext.eval(el);
        }
        String tagName = el.getTagName();
        TagReader tr = this.getTagReaders().get(tagName);
        if (tr != null) {
            return tr.read(el);
        }
        Class cls = this.getClassOfTag(tagName);
        if (cls == null) {
            throw new Error("can't find class for tag: " + tagName);
        }
        Object obj = this.createObject(cls, el);
        if (obj == null) {
            throw new Error("can't create instance of class " + cls + " for tag " + tagName);
        }
        List<Element> restored = this.restoreProperties(obj, cls, el);
        if (obj instanceof List) {
            r2 = this.restoreListEntries((List)obj, el, restored);
            restored.addAll(r2);
        }
        if (obj instanceof Set) {
            r2 = this.restoreSetEntries((Set)obj, el, restored);
            restored.addAll(r2);
        }
        if (obj instanceof Map) {
            r2 = this.restoreMapEntries((Map)obj, el, restored);
            restored.addAll(r2);
        }
        return obj;
    }

    public void writeXml(java.io.File target, Object value) {
        if (target == null) {
            throw new IllegalArgumentException("target==null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value==null");
        }
        try {
            FileOutputStream fout = new FileOutputStream(target);
            this.writeXml(fout, value);
            fout.flush();
            fout.close();
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public void writeXml(File target, Object value) {
        if (target == null) {
            throw new IllegalArgumentException("target==null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value==null");
        }
        try {
            BufferedOutputStream fout = target.openWrite();
            this.writeXml(fout, value);
            ((OutputStream)fout).flush();
            ((OutputStream)fout).close();
        }
        catch (IOException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public void writeXml(Writer target, Object value) {
        if (target == null) {
            throw new IllegalArgumentException("target==null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value==null");
        }
        try {
            FormatXMLWriter xmlwr = new FormatXMLWriter(target);
            xmlwr.setWriteOutline(true);
            xmlwr.setSpacer("\t");
            xmlwr.setNewline(EndLine.Default.get());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            Document doc = XMLUtil.createDocument();
            Map<String, Func1<String, String>> procInstrs = this.getProcessingInstructions();
            if (procInstrs != null) {
                for (Map.Entry<String, Func1<String, String>> pinst : procInstrs.entrySet()) {
                    ProcessingInstruction pins;
                    String v;
                    if (pinst == null) continue;
                    String ptarget = pinst.getKey();
                    Func1<String, String> ftarget = pinst.getValue();
                    if (ptarget == null || ftarget == null || (v = (String)ftarget.apply((Object)ptarget)) == null || (pins = doc.createProcessingInstruction(ptarget, v)) == null) continue;
                    doc.appendChild(pins);
                }
            }
            Node el = this.encode(value, doc);
            doc.appendChild(el);
            DOMSource source = new DOMSource(doc);
            StAXResult result = new StAXResult(xmlwr);
            transformer.transform(source, result);
            xmlwr.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeXml(OutputStream target, Object value) {
        if (target == null) {
            throw new IllegalArgumentException("target==null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value==null");
        }
        int indent = 4;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("indent-number", new Integer(indent));
            Transformer transformer = tFactory.newTransformer();
            Document doc = XMLUtil.createDocument();
            Map<String, Func1<String, String>> procInstrs = this.getProcessingInstructions();
            if (procInstrs != null) {
                for (Map.Entry<String, Func1<String, String>> pinst : procInstrs.entrySet()) {
                    ProcessingInstruction pins;
                    String v;
                    if (pinst == null) continue;
                    String ptarget = pinst.getKey();
                    Func1<String, String> ftarget = pinst.getValue();
                    if (ptarget == null || ftarget == null || (v = (String)ftarget.apply((Object)ptarget)) == null || (pins = doc.createProcessingInstruction(ptarget, v)) == null) continue;
                    doc.appendChild(pins);
                }
            }
            Node el = this.encode(value, doc);
            doc.appendChild(el);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(target);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex);
        }
        catch (TransformerException ex) {
            throw new Error(ex);
        }
    }

    public Node encode(Object value) {
        if (value == null) {
            return null;
        }
        return this.encode(value, null);
    }

    public Set<Class> getSimpleTypes() {
        if (this.simpleTypes != null) {
            return this.simpleTypes;
        }
        this.simpleTypes = new LinkedHashSet<Class>();
        this.simpleTypes.addAll(Arrays.asList(SimpleTypes.simpleTypes()));
        for (Class c : this.getTypeCast().getNodes()) {
            if (c == null) continue;
            this.simpleTypes.add(c);
        }
        return this.simpleTypes;
    }

    public void setSimpleTypes(Set<Class> simpleTypes) {
        this.simpleTypes = simpleTypes;
    }

    public Set<Class> getSuperSimpleTypes() {
        if (this.superSimpleTypes != null) {
            return this.superSimpleTypes;
        }
        this.superSimpleTypes = new LinkedHashSet<Class>();
        return this.superSimpleTypes;
    }

    public void setSuperSimpleTypes(Set<Class> superSimpleTypes) {
        this.superSimpleTypes = superSimpleTypes;
    }

    public Node encode(Object value, Document doc) {
        if (value == null) {
            return null;
        }
        if (doc == null) {
            doc = XMLUtil.createDocument();
        }
        if (this.getSimpleTypes().contains(value.getClass())) {
            return this.encodeSimpleType(value, doc);
        }
        if (!this.getSuperSimpleTypes().isEmpty()) {
            Class<?> vclass = value.getClass();
            for (Class supertype : this.getSuperSimpleTypes()) {
                if (supertype == null || !supertype.isAssignableFrom(vclass)) continue;
                return this.encodeSimpleType(value, doc);
            }
        }
        if (value instanceof String) {
            return this.encodeStringType((String)value, doc);
        }
        if (value.getClass().isEnum()) {
            return this.encodeEnumType(value, doc);
        }
        return this.encodeCombinedType(value, doc);
    }

    protected Node encodeEnumType(Object enumValue, Document doc) {
        Text txt = doc.createTextNode(((Enum)enumValue).name());
        return txt;
    }

    protected Node encodeSimpleType(Object simpleValue, Document doc) {
        TypeCastGraph tc = this.getTypeCast();
        return doc.createTextNode((String)tc.cast(simpleValue, String.class));
    }

    protected Node encodeStringType(String stringValue, Document doc) {
        return doc.createTextNode(stringValue);
    }

    protected String generateTagName(Class cls) {
        String cn = cls.getName();
        cn = cn.replace("$", "-");
        this.getClass2tag().put(cls, cn);
        return cn;
    }

    protected String getTagNameOf(Class cls) {
        String mappedTag = this.getClass2tag().get(cls);
        if (mappedTag != null) {
            return mappedTag;
        }
        return this.generateTagName(cls);
    }

    public void storeProperties(Object value, Element valueEl, Document doc) {
        Class<?> cls = value.getClass();
        Map<String, PropertyDescriptor> props = this.getPropertiesOf(cls);
        if (props != null) {
            for (Map.Entry<String, PropertyDescriptor> pd : props.entrySet()) {
                Method readmeth;
                Class<?> type = pd.getValue().getPropertyType();
                if (type == null || (readmeth = pd.getValue().getReadMethod()) == null || readmeth.getParameterTypes().length > 0) continue;
                try {
                    Object v = readmeth.invoke(value, new Object[0]);
                    this.storeProperty(pd.getKey(), v, type, value, valueEl, doc);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void storeProperty(String propertyName, Object propertyValue, Class propertyType, Object propertyOwner, Element ownerElement, Document doc) {
        PropertyWriter pw;
        if (propertyName == null) {
            return;
        }
        if (propertyValue == null) {
            return;
        }
        Class<?> ownerClass = propertyOwner.getClass();
        Map<String, PropertyWriter> propwr = this.propertiesWriter.get(ownerClass);
        if (propwr != null && (pw = propwr.get(propertyName)) != null) {
            pw.storeProperty(propertyName, propertyValue, propertyType, propertyOwner, ownerElement);
            return;
        }
        Element e = doc.createElement(propertyName);
        Node ne = this.encode(propertyValue, doc);
        if (ne != null) {
            ownerElement.appendChild(e);
            e.appendChild(ne);
        }
    }

    public String getListEntryTagName() {
        return "list-entry";
    }

    public void storeListEntries(List list, Element listOwnerElement, Document doc) {
        int index = -1;
        for (Object listEntry : list) {
            ++index;
            if (listEntry == null) continue;
            Node ne = this.encode(listEntry, doc);
            if (ne instanceof Text) {
                Element el = doc.createElement(this.getListEntryTagName());
                el.appendChild(ne);
                Class<?> listEntryClass = listEntry.getClass();
                el.setAttribute("type", listEntryClass.getName());
                el.setAttribute("index", Integer.toString(index));
                for (Class superType : this.getSuperSimpleTypes()) {
                    if (superType == null || !superType.isAssignableFrom(listEntryClass)) continue;
                    el.setAttribute("super-type", superType.getName());
                    break;
                }
                listOwnerElement.appendChild(el);
                continue;
            }
            listOwnerElement.appendChild(ne);
        }
    }

    public String getSetEntryTagName() {
        return "set-entry";
    }

    public void storeSetEntries(Set set, Element setOwnerElement, Document doc) {
        int index = -1;
        for (Object setEntry : set) {
            ++index;
            if (setEntry == null) continue;
            Node ne = this.encode(setEntry, doc);
            if (ne instanceof Text) {
                Element el = doc.createElement(this.getSetEntryTagName());
                el.appendChild(ne);
                Class<?> setEntryClass = setEntry.getClass();
                el.setAttribute("type", setEntryClass.getName());
                el.setAttribute("index", Integer.toString(index));
                for (Class superType : this.getSuperSimpleTypes()) {
                    if (superType == null || !superType.isAssignableFrom(setEntryClass)) continue;
                    el.setAttribute("super-type", superType.getName());
                    break;
                }
                setOwnerElement.appendChild(el);
                continue;
            }
            if (!(ne instanceof Element)) continue;
            setOwnerElement.appendChild(ne);
        }
    }

    public String getMapEntryTagName() {
        return "map-entry";
    }

    public void storeMapEntries(Map map, Element mapOwnerElement, Document doc) {
        int index = -1;
        for (Map.Entry mapEntry0 : map.entrySet()) {
            boolean sup1;
            Node n;
            ++index;
            if (mapEntry0 == null || !(mapEntry0 instanceof Map.Entry)) continue;
            Map.Entry en = mapEntry0;
            Object keyObj = en.getKey();
            Object valObj = en.getValue();
            Element entryEl = doc.createElement(this.getMapEntryTagName());
            mapOwnerElement.appendChild(entryEl);
            if (keyObj == null) {
                Element ekey = doc.createElement("key");
                ekey.setAttribute("isnull", "true");
                entryEl.appendChild(ekey);
            } else {
                n = this.encode(keyObj, doc);
                if (n instanceof Text) {
                    Element ekey = doc.createElement("key");
                    Class<?> keyClass = keyObj.getClass();
                    ekey.setAttribute("type", keyClass.getName());
                    for (Class superType : this.getSuperSimpleTypes()) {
                        if (superType == null || !(sup1 = superType.isAssignableFrom(keyClass))) continue;
                        ekey.setAttribute("super-type", superType.getName());
                        break;
                    }
                    ekey.appendChild(n);
                    entryEl.appendChild(ekey);
                } else if (n instanceof Element) {
                    entryEl.appendChild(n);
                }
            }
            if (valObj == null) {
                Element eval = doc.createElement("value");
                eval.setAttribute("isnull", "true");
                entryEl.appendChild(eval);
                continue;
            }
            n = this.encode(valObj, doc);
            if (n instanceof Text) {
                Element eval = doc.createElement("value");
                Class<?> valClass = valObj.getClass();
                eval.setAttribute("type", valClass.getName());
                for (Class superType : this.getSuperSimpleTypes()) {
                    if (superType == null || !(sup1 = superType.isAssignableFrom(valClass))) continue;
                    eval.setAttribute("super-type", superType.getName());
                    break;
                }
                eval.appendChild(n);
                entryEl.appendChild(eval);
                continue;
            }
            if (!(n instanceof Element)) continue;
            entryEl.appendChild(n);
        }
    }

    public Map<Class, CombinedTypeWriter> getClassWriters() {
        return this.classWriters;
    }

    protected Element encodeCombinedType(Object value, Document doc) {
        Class<?> cls = value.getClass();
        CombinedTypeWriter ctw = this.getClassWriters().get(cls);
        if (ctw != null) {
            return ctw.encodeCombinedType(value, doc);
        }
        String tagName = this.getTagNameOf(cls);
        if (tagName == null) {
            return null;
        }
        Element el = doc.createElement(tagName);
        this.storeProperties(value, el, doc);
        if (value instanceof List) {
            this.storeListEntries((List)value, el, doc);
        }
        if (value instanceof Set) {
            this.storeSetEntries((Set)value, el, doc);
        }
        if (value instanceof Map) {
            this.storeMapEntries((Map)value, el, doc);
        }
        return el;
    }

    public static interface CombinedTypeWriter {
        public Element encodeCombinedType(Object var1, Document var2);
    }

    public static interface TagReader {
        public Object read(Element var1);
    }

    public class Type {
        public final Class type;
        private String tag = null;
        private boolean writeListEntries = true;
        private boolean writeMapEntries = true;
        private boolean writeSetEntries = true;
        private boolean writeProperties = true;
        private boolean toStringContent = false;

        public Type(Class type) {
            this.type = type;
        }

        public Type tag(String tagname) {
            this.tag = tagname;
            return this;
        }

        public Type list(boolean writeListEntries) {
            this.writeListEntries = writeListEntries;
            return this;
        }

        public Type map(boolean writeMapEntries) {
            this.writeMapEntries = writeMapEntries;
            return this;
        }

        public Type set(boolean writeSetEntries) {
            this.writeSetEntries = writeSetEntries;
            return this;
        }

        public Type properties(boolean writeProperties) {
            this.writeProperties = writeProperties;
            return this;
        }

        public Properties properties() {
            return new Properties();
        }

        public Prop property(String name) {
            return new Prop(name);
        }

        public Type toStringContent(boolean toStringContent) {
            this.toStringContent = toStringContent;
            return this;
        }

        public XmlCoder build() {
            if (this.tag != null) {
                XmlCoder.this.map(this.tag, this.type);
            }
            CombinedTypeWriter cw = new CombinedTypeWriter(){

                @Override
                public Element encodeCombinedType(Object value, Document doc) {
                    Class<?> cls = value.getClass();
                    String tagName = XmlCoder.this.getTagNameOf(cls);
                    if (tagName == null) {
                        return null;
                    }
                    Element el = doc.createElement(tagName);
                    if (Type.this.writeProperties) {
                        XmlCoder.this.storeProperties(value, el, doc);
                    }
                    if (value instanceof List && Type.this.writeListEntries) {
                        XmlCoder.this.storeListEntries((List)value, el, doc);
                    }
                    if (value instanceof Set && Type.this.writeSetEntries) {
                        XmlCoder.this.storeSetEntries((Set)value, el, doc);
                    }
                    if (value instanceof Map && Type.this.writeMapEntries) {
                        XmlCoder.this.storeMapEntries((Map)value, el, doc);
                    }
                    if (Type.this.toStringContent) {
                        Text n = doc.createTextNode(value.toString());
                        el.appendChild(n);
                    }
                    return el;
                }
            };
            XmlCoder.this.getClassWriters().put(this.type, cw);
            return XmlCoder.this;
        }

        public class Prop {
            public final String property;
            public TypeCastGraph tc;

            public Prop(String property) {
                this.property = property;
            }

            public Type asis() {
                return Type.this;
            }

            public Type asAttribute(String attribute) {
                XmlCoder.this.property(Type.this.type, this.property).asAttribute(attribute, this.tc);
                return Type.this;
            }

            public Type asAttribute(String attribute, TypeCastGraph tc) {
                XmlCoder.this.property(Type.this.type, this.property).asAttribute(attribute, tc);
                return Type.this;
            }

            public Type asAttribute(final String attribute, final Convertor toString, final Convertor fromString) {
                PropertyWriter pw = new PropertyWriter(){

                    @Override
                    public void storeProperty(String propertyName, Object propertyValue, Class propertyType, Object propertyOwner, Element ownerElement) {
                        Object ostr = toString.convert(propertyValue);
                        if (ostr != null) {
                            ownerElement.setAttribute(attribute, ostr.toString());
                        }
                    }
                };
                PropertyReader pr = new PropertyReader(){

                    @Override
                    public boolean restoreAttribute(Object propertyOwner, Method writeMethod, String attributeValue, Element tag) {
                        Object v = fromString.convert((Object)attributeValue);
                        try {
                            writeMethod.invoke(propertyOwner, v);
                            return true;
                        }
                        catch (IllegalAccessException ex) {
                            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (InvocationTargetException ex) {
                            Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        return false;
                    }

                    @Override
                    public boolean restoreChildTag(Object propertyOwner, Method writeMethod, Element childTag, Element ownerTag) {
                        return false;
                    }

                    @Override
                    public String getPropertyName() {
                        return Prop.this.property;
                    }
                };
                Map<String, PropertyReader> proprdmap = XmlCoder.this.getPropertiesReader().get(Type.this.type);
                if (proprdmap == null) {
                    proprdmap = new LinkedHashMap<String, PropertyReader>();
                    XmlCoder.this.getPropertiesReader().put(Type.this.type, proprdmap);
                }
                proprdmap.put(this.property, pr);
                Map<String, PropertyWriter> propwrmap = XmlCoder.this.getPropertiesWriter().get(Type.this.type);
                if (propwrmap == null) {
                    propwrmap = new LinkedHashMap<String, PropertyWriter>();
                    XmlCoder.this.getPropertiesWriter().put(Type.this.type, propwrmap);
                }
                propwrmap.put(this.property, pw);
                return Type.this;
            }

            public Type ignoreWrite() {
                PropertyWriter pw = new PropertyWriter(){

                    @Override
                    public void storeProperty(String propertyName, Object propertyValue, Class propertyType, Object propertyOwner, Element ownerElement) {
                    }
                };
                Map<String, PropertyWriter> propwrmap = XmlCoder.this.getPropertiesWriter().get(Type.this.type);
                if (propwrmap == null) {
                    propwrmap = new LinkedHashMap<String, PropertyWriter>();
                    XmlCoder.this.getPropertiesWriter().put(Type.this.type, propwrmap);
                }
                propwrmap.put(this.property, pw);
                return Type.this;
            }

            public Type ignoreRead() {
                PropertyReader pr = new PropertyReader(){

                    @Override
                    public boolean restoreAttribute(Object propertyOwner, Method writeMethod, String attributeValue, Element tag) {
                        return true;
                    }

                    @Override
                    public boolean restoreChildTag(Object propertyOwner, Method writeMethod, Element childTag, Element ownerTag) {
                        return true;
                    }

                    @Override
                    public String getPropertyName() {
                        return Prop.this.property;
                    }
                };
                Map<String, PropertyReader> proprdmap = XmlCoder.this.getPropertiesReader().get(Type.this.type);
                if (proprdmap == null) {
                    proprdmap = new LinkedHashMap<String, PropertyReader>();
                    XmlCoder.this.getPropertiesReader().put(Type.this.type, proprdmap);
                }
                proprdmap.put(this.property, pr);
                return Type.this;
            }

            public Type ignore() {
                this.ignoreRead();
                this.ignoreWrite();
                return Type.this;
            }

            public Type writer(PropertyWriter pw) {
                if (pw == null) {
                    Map<String, PropertyWriter> propwrmap = XmlCoder.this.getPropertiesWriter().get(Type.this.type);
                    if (propwrmap == null) {
                        return Type.this;
                    }
                    propwrmap.remove(this.property);
                    return Type.this;
                }
                Map<String, PropertyWriter> propwrmap = XmlCoder.this.getPropertiesWriter().get(Type.this.type);
                if (propwrmap == null) {
                    propwrmap = new LinkedHashMap<String, PropertyWriter>();
                    XmlCoder.this.getPropertiesWriter().put(Type.this.type, propwrmap);
                }
                propwrmap.put(this.property, pw);
                return Type.this;
            }

            public Type reader(PropertyReader pr) {
                if (pr == null) {
                    Map<String, PropertyReader> proprdmap = XmlCoder.this.getPropertiesReader().get(Type.this.type);
                    if (proprdmap == null) {
                        return Type.this;
                    }
                    proprdmap.remove(this.property);
                    return Type.this;
                }
                Map<String, PropertyReader> proprdmap = XmlCoder.this.getPropertiesReader().get(Type.this.type);
                if (proprdmap == null) {
                    proprdmap = new LinkedHashMap<String, PropertyReader>();
                    XmlCoder.this.getPropertiesReader().put(Type.this.type, proprdmap);
                }
                proprdmap.put(this.property, pr);
                return Type.this;
            }
        }

        public class Properties {
            public Type order(String ... propertiesNames) {
                LinkedHashMap<String, Integer> orderMap = (LinkedHashMap<String, Integer>)XmlCoder.this.propertiesOrder.get(Type.this.type);
                if (orderMap == null) {
                    orderMap = new LinkedHashMap<String, Integer>();
                    XmlCoder.this.propertiesOrder.put(Type.this.type, orderMap);
                }
                int ordIdx = 0;
                for (String propName : propertiesNames) {
                    ++ordIdx;
                    if (propName == null) continue;
                    orderMap.put(propName, ordIdx);
                }
                return Type.this;
            }
        }
    }

    public class Attribute {
        public Class cls;
        public String propertyName;

        public XmlCoder asAttribute(String attribute) {
            return this.asAttribute(attribute, null);
        }

        public XmlCoder asAttribute(final String attribute, final TypeCastGraph tc) {
            if (attribute == null) {
                throw new IllegalArgumentException("attribute==null");
            }
            PropertyWriter pw = new PropertyWriter(){

                @Override
                public void storeProperty(String propertyName, Object propertyValue, Class propertyType, Object propertyOwner, Element ownerElement) {
                    TypeCastGraph tcg = tc == null ? XmlCoder.this.getTypeCast() : tc;
                    try {
                        if (propertyType != null && propertyType.isEnum() && propertyValue != null) {
                            String v = ((Enum)propertyValue).toString();
                            ownerElement.setAttribute(attribute, v);
                        } else if (propertyValue != null) {
                            String v = (String)tcg.cast(propertyValue, String.class);
                            ownerElement.setAttribute(attribute, v);
                        }
                    }
                    catch (Throwable err) {
                        throw new ClassCastException("from " + propertyValue + " to String");
                    }
                }
            };
            Map<String, PropertyWriter> propwrmap = XmlCoder.this.getPropertiesWriter().get(this.cls);
            if (propwrmap == null) {
                propwrmap = new LinkedHashMap<String, PropertyWriter>();
                XmlCoder.this.getPropertiesWriter().put(this.cls, propwrmap);
            }
            propwrmap.put(this.propertyName, pw);
            PropertyReader pr = new PropertyReader(){

                @Override
                public boolean restoreAttribute(Object propertyOwner, Method writeMethod, String attributeValue, Element tag) {
                    if (writeMethod == null) {
                        return false;
                    }
                    if (attributeValue == null) {
                        return false;
                    }
                    if (propertyOwner == null) {
                        return false;
                    }
                    if (writeMethod.getParameterTypes().length != 1) {
                        return false;
                    }
                    Object v = null;
                    boolean vassigned = false;
                    Class<?>[] paramTypes = writeMethod.getParameterTypes();
                    Class<?> paramType = paramTypes[0];
                    if (paramType.isEnum() && attributeValue != null) {
                        v = Enum.valueOf(paramType, attributeValue);
                        vassigned = true;
                    }
                    if (!vassigned) {
                        Class<?> targetType = writeMethod.getParameterTypes()[0];
                        TypeCastGraph tcg = tc == null ? XmlCoder.this.getTypeCast() : tc;
                        try {
                            v = tcg.cast((Object)attributeValue, targetType);
                        }
                        catch (Throwable err) {
                            throw new ClassCastException("from string " + attributeValue + " to " + targetType);
                        }
                    }
                    try {
                        writeMethod.invoke(propertyOwner, v);
                        return true;
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                        throw new Error(ex.getMessage(), ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                        throw new Error(ex.getMessage(), ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(XmlCoder.class.getName()).log(Level.SEVERE, null, ex);
                        throw new Error(ex.getMessage(), ex);
                    }
                }

                @Override
                public String getPropertyName() {
                    return Attribute.this.propertyName;
                }

                @Override
                public boolean restoreChildTag(Object propertyOwner, Method writeMethod, Element childTag, Element ownerTag) {
                    return false;
                }
            };
            Map<String, PropertyReader> proprdmap = XmlCoder.this.getPropertiesReader().get(this.cls);
            if (proprdmap == null) {
                proprdmap = new LinkedHashMap<String, PropertyReader>();
                XmlCoder.this.getPropertiesReader().put(this.cls, proprdmap);
            }
            proprdmap.put(attribute, pr);
            return XmlCoder.this;
        }
    }

    public static interface PropertyWriter {
        public void storeProperty(String var1, Object var2, Class var3, Object var4, Element var5);
    }

    public static interface PropertyReader {
        public String getPropertyName();

        public boolean restoreAttribute(Object var1, Method var2, String var3, Element var4);

        public boolean restoreChildTag(Object var1, Method var2, Element var3, Element var4);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Ignore {
    }
}

