/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xyz.cofe.collection.BasicVisitor;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.Visitor;
import xyz.cofe.fs.File;
import xyz.cofe.io.IOFun;
import xyz.cofe.text.Text;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.XMLNodeIterable;

public class XMLUtil {
    private static String trasformErrorResult = "XSLT ERROR";
    private static DocumentBuilderFactory docBuilderFactory = null;
    private static DocumentBuilder builder = null;
    public static final NodesExtracter<Node, Node> xmlChildExtracter = new NodesExtracter<Node, Node>(){

        public Iterable<Node> extract(Node from) {
            Document d;
            Element e;
            if (from == null) {
                return null;
            }
            if (from instanceof Element) {
                return XMLUtil.xmlNodes(((Element)from).getChildNodes());
            }
            if (from instanceof Document && (e = (d = (Document)from).getDocumentElement()) instanceof Node) {
                return Iterators.single((Object)e);
            }
            return null;
        }
    };
    private static XPathFactory xpathFactory = null;
    private static XPath xpath = null;

    public static Transformer createXSLT(String xslStyle) {
        try {
            if (xslStyle == null) {
                return null;
            }
            StringReader stringReader = new StringReader(xslStyle);
            StreamSource source = new StreamSource(stringReader);
            Transformer t = TransformerFactory.newInstance().newTransformer(source);
            return t;
        }
        catch (TransformerConfigurationException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public static Transformer createXSLT(URL urlXSLT, Charset cs) {
        String text;
        if (urlXSLT == null) {
            return null;
        }
        if (cs == null) {
            return null;
        }
        try {
            text = IOFun.readText((URL)urlXSLT, (Charset)cs);
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        if (text == null) {
            return null;
        }
        return XMLUtil.createXSLT(text);
    }

    public static Transformer createXSLT(java.io.File xsltFile, Charset cs) {
        String text;
        if (xsltFile == null) {
            return null;
        }
        if (cs == null) {
            return null;
        }
        try {
            text = IOFun.readText((java.io.File)xsltFile, (Charset)cs);
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        return XMLUtil.createXSLT(text);
    }

    public static String toStringXSLT(Transformer trans, String xml, String errResult) {
        if (trans == null) {
            return errResult;
        }
        if (xml == null) {
            return errResult;
        }
        StringReader sread = new StringReader(xml);
        StringWriter swriter = new StringWriter();
        try {
            FormatXMLWriter fxmlWriter = new FormatXMLWriter(swriter);
            fxmlWriter.setWriteStartDocument(false);
            StAXResult result = new StAXResult(fxmlWriter);
            StreamSource source = new StreamSource(sread);
            trans.transform(source, result);
            fxmlWriter.flush();
        }
        catch (TransformerException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        catch (XMLStreamException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        return swriter.toString();
    }

    public static String toStringXSLT(String xsl, String srcXml) {
        if (xsl == null) {
            throw new IllegalArgumentException("xsl == null");
        }
        Transformer trfm = XMLUtil.createXSLT(xsl);
        if (trfm == null) {
            return null;
        }
        return XMLUtil.toStringXSLT(trfm, srcXml);
    }

    public static String toStringXSLT(Transformer trans, String xml) {
        return XMLUtil.toStringXSLT(trans, xml, trasformErrorResult);
    }

    public static DocumentBuilderFactory docBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return docBuilderFactory;
    }

    public static DocumentBuilder docBuilder() {
        if (builder == null) {
            try {
                builder = XMLUtil.docBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                builder = null;
                throw new Error(ex.getMessage(), ex);
            }
        }
        return builder;
    }

    public static Document createDocument() {
        DocumentBuilder b = XMLUtil.docBuilder();
        Document res = null;
        if (b != null) {
            res = b.newDocument();
        }
        return res;
    }

    public static void visit(Visitor<Node> visitor, Node start) {
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        BasicVisitor.visit(visitor, (Object)start, xmlChildExtracter);
    }

    public static Iterable<Node> children(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (!node.hasChildNodes()) {
            return Iterators.empty();
        }
        return XMLUtil.xmlNodes(node.getChildNodes());
    }

    public static Iterable<Element> elements(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (!node.hasChildNodes()) {
            return Iterators.empty();
        }
        return Iterators.convert(XMLUtil.filter(XMLUtil.xmlNodes(node.getChildNodes()), Predicates.isElement), (Convertor)new Convertor<Node, Element>(){

            public Element convert(Node from) {
                return from instanceof Element ? (Element)from : null;
            }
        });
    }

    public static Iterable<Element> elements(Node node, Predicate<Node> pred) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (!node.hasChildNodes()) {
            return Iterators.empty();
        }
        return Iterators.convert(XMLUtil.filter(XMLUtil.xmlNodes(node.getChildNodes()), Predicates.and(Predicates.isElement, pred)), (Convertor)new Convertor<Node, Element>(){

            public Element convert(Node from) {
                return from instanceof Element ? (Element)from : null;
            }
        });
    }

    public static Iterable<Node> filter(Iterable<Node> src, Predicate<Node> pred) {
        return Iterators.predicate(src, pred);
    }

    public static Iterable<Node> filter(Node[] src, Predicate<Node> pred) {
        return Iterators.predicate((Object[])src, pred);
    }

    public static String getText(Node n) {
        if (n == null) {
            throw new IllegalArgumentException("n == null");
        }
        final StringBuilder sb = new StringBuilder();
        Visitor<Node> v = new Visitor<Node>(){

            public boolean enter(Node n) {
                if (n instanceof Text) {
                    sb.append(n.getNodeValue());
                }
                return true;
            }

            public void exit(Node n) {
            }
        };
        XMLUtil.visit(v, n);
        return sb.toString();
    }

    public static String toXMLString(NodeList nodeList) {
        if (nodeList == null) {
            throw new IllegalArgumentException("nodeList == null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            sb.append(XMLUtil.toXMLString(nodeList.item(i)));
        }
        return sb.toString();
    }

    public static void write(final XMLStreamWriter writer, Node doc) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (doc == null) {
            throw new IllegalArgumentException("doc == null");
        }
        final HashSet failedElements = new HashSet();
        Visitor<Node> v = new Visitor<Node>(){

            public boolean enter(Node n) {
                block31: {
                    block34: {
                        block33: {
                            block32: {
                                block30: {
                                    if (!(n instanceof Element)) break block30;
                                    String namespaceURI = n.getNamespaceURI();
                                    String prefix = n.getPrefix();
                                    String name = n.getNodeName();
                                    if (namespaceURI == null) {
                                        try {
                                            writer.writeStartElement(name);
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                            failedElements.add(n);
                                            return false;
                                        }
                                    }
                                    if (prefix != null) {
                                        try {
                                            writer.writeStartElement(prefix, name, namespaceURI);
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    } else {
                                        try {
                                            writer.writeStartElement(namespaceURI, name);
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                    if (!n.hasAttributes()) break block31;
                                    NamedNodeMap nnm = n.getAttributes();
                                    for (int i = 0; i < nnm.getLength(); ++i) {
                                        Node nAttr = nnm.item(i);
                                        if (nAttr == null) continue;
                                        String attrNamespaceURI = nAttr.getNamespaceURI();
                                        String attrPrefix = nAttr.getPrefix();
                                        String attrName = nAttr.getNodeName();
                                        String attrValue = nAttr.getTextContent();
                                        if (attrNamespaceURI != null && attrPrefix != null && attrName != null) {
                                            try {
                                                writer.writeAttribute(attrPrefix, attrNamespaceURI, attrName, attrValue == null ? "" : attrValue);
                                            }
                                            catch (XMLStreamException ex) {
                                                Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            continue;
                                        }
                                        if (attrNamespaceURI != null && attrPrefix == null && attrName != null) {
                                            try {
                                                writer.writeAttribute(attrNamespaceURI, attrName, attrValue == null ? "" : attrValue);
                                            }
                                            catch (XMLStreamException ex) {
                                                Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            continue;
                                        }
                                        if (attrNamespaceURI != null || attrPrefix != null || attrName == null) continue;
                                        try {
                                            writer.writeAttribute(attrName, attrValue == null ? "" : attrValue);
                                            continue;
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                    break block31;
                                }
                                if (!(n instanceof Text)) break block32;
                                Text txt = (Text)n;
                                String value = txt.getNodeValue();
                                try {
                                    writer.writeCharacters(value);
                                }
                                catch (XMLStreamException ex) {
                                    Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                break block31;
                            }
                            if (!(n instanceof CDATASection)) break block33;
                            CDATASection cdata = (CDATASection)n;
                            try {
                                writer.writeCData(cdata.getNodeValue());
                            }
                            catch (XMLStreamException ex) {
                                Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break block31;
                        }
                        if (!(n instanceof Comment)) break block34;
                        Comment comment = (Comment)n;
                        try {
                            writer.writeComment(comment.getNodeValue());
                        }
                        catch (XMLStreamException ex) {
                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break block31;
                    }
                    if (!(n instanceof ProcessingInstruction)) break block31;
                    ProcessingInstruction instr = (ProcessingInstruction)n;
                    String target = instr.getTarget();
                    String data = instr.getData();
                    if (data != null) {
                        try {
                            writer.writeProcessingInstruction(target, data);
                        }
                        catch (XMLStreamException ex) {
                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        try {
                            writer.writeProcessingInstruction(target);
                        }
                        catch (XMLStreamException ex) {
                            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                return true;
            }

            public void exit(Node n) {
                if (n instanceof Element) {
                    if (failedElements.contains(n)) {
                        return;
                    }
                    try {
                        writer.writeEndElement();
                    }
                    catch (XMLStreamException ex) {
                        Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        XMLUtil.visit(v, doc);
    }

    public static String toXMLString(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("doc == null");
        }
        StringWriter sw = new StringWriter();
        DOMSource srcDom = new DOMSource(node);
        StreamResult resStrm = new StreamResult();
        resStrm.setWriter(sw);
        TransformerFactory tfact = TransformerFactory.newInstance();
        try {
            Transformer transformer = tfact.newTransformer();
            transformer.transform(srcDom, resStrm);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage(), ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage(), ex);
        }
        return sw.toString();
    }

    public static Document parseXML(java.io.File file) throws IOException, SAXException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        FileInputStream fin = new FileInputStream(file);
        Document doc = XMLUtil.parseXML(fin);
        fin.close();
        return doc;
    }

    public static Document parseXML(File file) throws IOException, SAXException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        BufferedInputStream instr = file.openRead();
        Document doc = XMLUtil.parseXML(instr);
        ((InputStream)instr).close();
        return doc;
    }

    public static Document parseXML(InputStream xml) throws IOException, SAXException {
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        DocumentBuilder b = XMLUtil.docBuilder();
        Document res = null;
        if (b != null) {
            InputSource inSrc = new InputSource(xml);
            try {
                res = b.parse(inSrc);
            }
            catch (SAXException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            finally {
                xml.close();
            }
        }
        return res;
    }

    public static Document parseXML(Reader xml) throws IOException, SAXException {
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        DocumentBuilder b = XMLUtil.docBuilder();
        Document res = null;
        if (b != null) {
            InputSource inSrc = new InputSource(xml);
            try {
                res = b.parse(inSrc);
            }
            catch (SAXException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return res;
    }

    public static Document parseXML(String xml) throws IOException, SAXException {
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        DocumentBuilder b = XMLUtil.docBuilder();
        Document res = null;
        if (b != null) {
            StringReader strRD = new StringReader(xml);
            InputSource inSrc = new InputSource(strRD);
            try {
                res = b.parse(inSrc);
            }
            catch (SAXException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            finally {
                strRD.close();
            }
        }
        return res;
    }

    public static Iterable<Node> xmlNodes(NodeList nl) {
        return new XMLNodeIterable(nl);
    }

    public static XPathFactory xpathFactory() {
        if (xpathFactory == null) {
            xpathFactory = XPathFactory.newInstance();
        }
        return xpathFactory;
    }

    public static XPath xpath() {
        XPathFactory f;
        if (xpath == null && (f = XMLUtil.xpathFactory()) != null) {
            xpath = f.newXPath();
        }
        return xpath;
    }

    public static String xpathString(String xpathQuery, Node xmldoc) {
        if (xpathQuery == null) {
            throw new IllegalArgumentException("xpathQuery == null");
        }
        if (xmldoc == null) {
            throw new IllegalArgumentException("xmldoc == null");
        }
        XPath x = XMLUtil.xpath();
        if (x != null) {
            try {
                return (String)x.evaluate(xpathQuery, xmldoc, XPathConstants.STRING);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static NodeList xpathNodeSet(String xpathQuery, Node xmldoc) {
        if (xpathQuery == null) {
            throw new IllegalArgumentException("xpathQuery == null");
        }
        if (xmldoc == null) {
            throw new IllegalArgumentException("xmldoc == null");
        }
        XPath x = XMLUtil.xpath();
        if (x != null) {
            try {
                return (NodeList)x.evaluate(xpathQuery, xmldoc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static Node xpathNode(String xpathQuery, Node xmldoc) {
        if (xpathQuery == null) {
            throw new IllegalArgumentException("xpathQuery == null");
        }
        if (xmldoc == null) {
            throw new IllegalArgumentException("xmldoc == null");
        }
        XPath x = XMLUtil.xpath();
        if (x != null) {
            try {
                return (Node)x.evaluate(xpathQuery, xmldoc, XPathConstants.NODE);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static Double xpathNumber(String xpathQuery, Node xmldoc) {
        if (xpathQuery == null) {
            throw new IllegalArgumentException("xpathQuery == null");
        }
        if (xmldoc == null) {
            throw new IllegalArgumentException("xmldoc == null");
        }
        XPath x = XMLUtil.xpath();
        if (x != null) {
            try {
                return (Double)x.evaluate(xpathQuery, xmldoc, XPathConstants.NUMBER);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static Boolean xpathBoolean(String xpathQuery, Node xmldoc) {
        if (xpathQuery == null) {
            throw new IllegalArgumentException("xpathQuery == null");
        }
        if (xmldoc == null) {
            throw new IllegalArgumentException("xmldoc == null");
        }
        XPath x = XMLUtil.xpath();
        if (x != null) {
            try {
                return (Boolean)x.evaluate(xpathQuery, xmldoc, XPathConstants.BOOLEAN);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static Node cloneXml(Node src) {
        try {
            Element docel;
            if (src == null) {
                throw new IllegalArgumentException("src==null");
            }
            DOMSource srcDom = new DOMSource(src);
            DOMResult resDom = new DOMResult();
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer transformer = tfact.newTransformer();
            transformer.transform(srcDom, resDom);
            Node res = resDom.getNode();
            if (src instanceof Element && res instanceof Document && (docel = ((Document)res).getDocumentElement()) != null) {
                return docel;
            }
            return res;
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage(), ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XMLUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage(), ex);
        }
    }

    public static class NullResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }

    public static class Predicates {
        public static final Predicate<Node> isElement = new Predicate<Node>(){

            public boolean validate(Node value) {
                if (value == null) {
                    return false;
                }
                return value instanceof Element;
            }
        };

        public static Predicate<Node> nodeName(final Predicate<String> nodeNamePredicate) {
            return new Predicate<Node>(){

                public boolean validate(Node value) {
                    if (value == null) {
                        return false;
                    }
                    if (nodeNamePredicate == null) {
                        return false;
                    }
                    return nodeNamePredicate.validate((Object)value.getNodeName());
                }
            };
        }

        public static Predicate<Node> nodeName(String nodeName, boolean ignoreCase) {
            return Predicates.nodeName((Predicate<String>)(ignoreCase ? Text.Predicates.equalsIgnoreCase((String)nodeName) : Text.Predicates.equals((String)nodeName)));
        }

        public static Predicate<Node> and(Predicate<Node> ... preds) {
            return xyz.cofe.collection.Predicates.and(preds);
        }

        public static Predicate<Node> or(Predicate<Node> ... preds) {
            return xyz.cofe.collection.Predicates.or(preds);
        }

        public static Predicate<Node> not(Predicate<Node> pred) {
            return xyz.cofe.collection.Predicates.not(pred);
        }
    }
}

