/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import xyz.cofe.xml.LevelXMLWriter;

public class OutlineXMLWriter
extends LevelXMLWriter {
    private ArrayList<Boolean> deepChild = new ArrayList();
    private String newline = null;
    private String spacer = "    ";
    private boolean writeOutline = true;

    public boolean isWriteOutline() {
        return this.writeOutline;
    }

    public void setWriteOutline(boolean writeOutline) {
        this.writeOutline = writeOutline;
    }

    public OutlineXMLWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public String getNewline() {
        if (this.newline == null) {
            this.newline = System.getProperty("line.separator", "\n");
        }
        return this.newline;
    }

    public void setNewline(String newline) {
        if (newline == null) {
            throw new IllegalArgumentException("newline==null");
        }
        this.newline = newline;
    }

    public String getSpacer() {
        if (this.spacer == null) {
            this.spacer = "\t";
        }
        return this.spacer;
    }

    public void setSpacer(String spacer) {
        if (spacer == null) {
            throw new IllegalArgumentException("spacer==null");
        }
        this.spacer = spacer;
    }

    protected void writeOutline(int level, boolean newline) throws XMLStreamException {
        if (newline) {
            this.getWriter().writeCharacters(this.getNewline());
        }
        if (level > 0) {
            for (int i = 0; i < level; ++i) {
                this.getWriter().writeCharacters(this.getSpacer());
            }
        }
    }

    protected void setLevelHasChildren(int level, boolean has) {
        if (level < 0) {
            return;
        }
        if (level >= this.deepChild.size()) {
            int needInsert = level - this.deepChild.size() + 1;
            for (int i = 0; i < needInsert; ++i) {
                this.deepChild.add(false);
            }
        }
        this.deepChild.set(level, has);
    }

    protected boolean isLevelHasChildren(int level) {
        if (level < 0 || level >= this.deepChild.size()) {
            return false;
        }
        return this.deepChild.get(level);
    }

    @Override
    protected void beginElement() throws XMLStreamException {
        int _level = this.getLevel();
        if (this.writeOutline) {
            this.writeOutline(_level, _level > 0);
        }
        this.setLevelHasChildren(_level, true);
        this.incrementLevel();
        this.setLevelHasChildren(_level + 1, false);
    }

    @Override
    protected void endElement() throws XMLStreamException {
        int _level = this.getLevel();
        if (this.isLevelHasChildren(_level) && this.writeOutline) {
            this.writeOutline(_level - 1, true);
        }
        this.decrementLevel();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        super.writeStartDocument(encoding, version);
        this.getWriter().writeCharacters(this.newline);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        super.writeStartDocument(version);
        this.getWriter().writeCharacters(this.newline);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        super.writeStartDocument();
        this.getWriter().writeCharacters(this.newline);
    }
}

