/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MTryCatchBlock
extends MAbstractBC
implements ByteCode,
MethodWriter {
    private static final long serialVersionUID = 1L;
    private String labelStart;
    private String labelEnd;
    private String labelHandler;
    private String type;

    public MTryCatchBlock() {
    }

    public MTryCatchBlock(String start, String end, String handler, String type) {
        this.labelStart = start;
        this.labelEnd = end;
        this.labelHandler = handler;
        this.type = type;
    }

    public MTryCatchBlock(MTryCatchBlock sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.labelStart = sample.labelStart;
        this.labelEnd = sample.labelEnd;
        this.labelHandler = sample.labelHandler;
        this.type = sample.type;
    }

    @Override
    public MTryCatchBlock clone() {
        return new MTryCatchBlock(this);
    }

    public String getLabelStart() {
        return this.labelStart;
    }

    public void setLabelStart(String labelStart) {
        this.labelStart = labelStart;
    }

    public String getLabelEnd() {
        return this.labelEnd;
    }

    public void setLabelEnd(String labelEnd) {
        this.labelEnd = labelEnd;
    }

    public String getLabelHandler() {
        return this.labelHandler;
    }

    public void setLabelHandler(String labelHandler) {
        this.labelHandler = labelHandler;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return MTryCatchBlock.class.getSimpleName() + " start=" + this.labelStart + " end=" + this.labelEnd + " handler=" + this.labelHandler + " type=" + this.type;
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx==null");
        }
        String ls = this.getLabelStart();
        String le = this.getLabelEnd();
        String lh = this.getLabelHandler();
        v.visitTryCatchBlock(ls != null ? ctx.labelCreateOrGet(ls) : null, le != null ? ctx.labelCreateOrGet(le) : null, lh != null ? ctx.labelCreateOrGet(lh) : null, this.getType());
    }
}

