/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MTableSwitchInsn
extends MAbstractBC
implements ByteCode,
MethodWriter {
    private static final long serialVersionUID = 1L;
    private int min;
    private int max;
    private String defaultLabel;
    private String[] labels;

    public MTableSwitchInsn() {
    }

    public MTableSwitchInsn(int min, int max, String dflt, String ... labels) {
        this.min = min;
        this.max = max;
        this.defaultLabel = dflt;
        this.labels = labels;
    }

    public MTableSwitchInsn(MTableSwitchInsn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.min = sample.min;
        this.max = sample.max;
        this.defaultLabel = sample.defaultLabel;
        if (sample.labels != null) {
            this.labels = Arrays.copyOf(sample.labels, sample.labels.length);
        }
    }

    @Override
    public MTableSwitchInsn clone() {
        return new MTableSwitchInsn(this);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public String toString() {
        return MTableSwitchInsn.class.getSimpleName() + " min=" + this.min + " max=" + this.max + (String)(this.defaultLabel != null ? " defLabel=" + this.defaultLabel : "") + (String)(this.labels != null ? " label=" + List.of(this.labels) : "");
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx==null");
        }
        String dl = this.getDefaultLabel();
        String[] ls = this.getLabels();
        v.visitTableSwitchInsn(this.getMin(), this.getMax(), dl != null ? ctx.labelCreateOrGet(dl) : null, ctx.labelsGet(ls));
    }
}

