/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationDef;
import xyz.cofe.trambda.bc.ann.GetAnnotationByteCodes;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MLocalVariableAnnotation
extends MAbstractBC
implements ByteCode,
AnnotationDef,
GetAnnotationByteCodes,
MethodWriter {
    private static final long serialVersionUID = 1L;
    protected int typeRef;
    protected String typePath;
    protected String[] startLabels;
    protected String[] endLabels;
    protected int[] index;
    protected String descriptor;
    protected boolean visible;
    protected List<AnnotationByteCode> annotationByteCodes;

    public MLocalVariableAnnotation() {
    }

    public MLocalVariableAnnotation(MLocalVariableAnnotation sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.typeRef = sample.typeRef;
        this.typePath = sample.typePath;
        if (sample.startLabels != null) {
            this.startLabels = Arrays.copyOf(sample.startLabels, sample.startLabels.length);
        }
        if (sample.endLabels != null) {
            this.endLabels = Arrays.copyOf(sample.endLabels, sample.endLabels.length);
        }
        if (sample.index != null) {
            this.index = Arrays.copyOf(sample.index, sample.index.length);
        }
        this.descriptor = sample.descriptor;
        this.visible = sample.visible;
        if (sample.annotationByteCodes != null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
            for (AnnotationByteCode b : sample.annotationByteCodes) {
                if (b != null) {
                    this.annotationByteCodes.add(b.clone());
                    continue;
                }
                this.annotationByteCodes.add(null);
            }
        }
    }

    @Override
    public MLocalVariableAnnotation clone() {
        return new MLocalVariableAnnotation(this);
    }

    public int getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(int typeRef) {
        this.typeRef = typeRef;
    }

    public String getTypePath() {
        return this.typePath;
    }

    public void setTypePath(String typePath) {
        this.typePath = typePath;
    }

    public String[] getStartLabels() {
        return this.startLabels;
    }

    public void setStartLabels(String[] startLabels) {
        this.startLabels = startLabels;
    }

    public String[] getEndLabels() {
        return this.endLabels;
    }

    public void setEndLabels(String[] endLabels) {
        this.endLabels = endLabels;
    }

    public int[] getIndex() {
        return this.index;
    }

    public void setIndex(int[] index) {
        this.index = index;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return MLocalVariableAnnotation.class.getSimpleName() + " typeRef=" + this.typeRef + " typePath=" + this.typePath + " startLabels=" + Arrays.toString(this.startLabels) + " endLabels=" + Arrays.toString(this.endLabels) + " index=" + Arrays.toString(this.index) + " descriptor=" + this.descriptor + " visible=" + this.visible;
    }

    @Override
    public List<AnnotationByteCode> getAnnotationByteCodes() {
        if (this.annotationByteCodes == null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
        }
        return this.annotationByteCodes;
    }

    public void setAnnotationByteCodes(List<AnnotationByteCode> byteCodes) {
        this.annotationByteCodes = byteCodes;
    }

    @Override
    public Eterable<ByteCode> nodes() {
        if (this.annotationByteCodes != null) {
            return Eterable.of(this.annotationByteCodes);
        }
        return Eterable.empty();
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx==null");
        }
        String tp = this.getTypePath();
        AnnotationVisitor av = v.visitLocalVariableAnnotation(this.getTypeRef(), tp != null ? TypePath.fromString((String)tp) : null, ctx.labelsGet(this.getStartLabels()), ctx.labelsGet(this.getEndLabels()), this.getIndex(), this.getDescriptor(), this.isVisible());
        List<AnnotationByteCode> abody = this.annotationByteCodes;
        if (abody != null) {
            int i = -1;
            for (AnnotationByteCode ab : abody) {
                ++i;
                if (ab != null) {
                    ab.write(av);
                    continue;
                }
                throw new IllegalStateException("annotationByteCodes[" + i + "]==null");
            }
        }
    }
}

