/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.cls;

import java.io.IOError;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import xyz.cofe.collection.ImTree;
import xyz.cofe.io.fn.IOFun;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.ClassDump;
import xyz.cofe.trambda.JavaClassName;
import xyz.cofe.trambda.bc.AccFlags;
import xyz.cofe.trambda.bc.AccFlagsProperty;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ClassFlags;
import xyz.cofe.trambda.bc.cls.CAnnotation;
import xyz.cofe.trambda.bc.cls.CField;
import xyz.cofe.trambda.bc.cls.CInnerClass;
import xyz.cofe.trambda.bc.cls.CMethod;
import xyz.cofe.trambda.bc.cls.CNestHost;
import xyz.cofe.trambda.bc.cls.CNestMember;
import xyz.cofe.trambda.bc.cls.COuterClass;
import xyz.cofe.trambda.bc.cls.CPermittedSubclass;
import xyz.cofe.trambda.bc.cls.CSource;
import xyz.cofe.trambda.bc.cls.CTypeAnnotation;
import xyz.cofe.trambda.bc.cls.ClazzWriter;
import xyz.cofe.trambda.bc.cls.ClsByteCode;

public class CBegin
implements ClsByteCode,
ImTree<ByteCode>,
ClazzWriter,
AccFlagsProperty,
ClassFlags {
    private static final long serialVersionUID = 1L;
    protected int version;
    protected int access;
    protected String name;
    protected String signature;
    protected String superName;
    protected String[] interfaces;
    protected CSource source;
    protected COuterClass outerClass;
    protected CNestHost nestHost;
    protected CPermittedSubclass permittedSubclass;
    protected List<CAnnotation> annotations;
    protected List<CTypeAnnotation> typeAnnotations;
    protected List<CNestMember> nestMembers;
    protected List<CInnerClass> innerClasses;
    protected List<CField> fields;
    protected List<CMethod> methods;
    protected Map<ClsByteCode, Integer> order;

    public CBegin() {
    }

    public CBegin(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.version = version;
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.superName = superName;
        this.interfaces = interfaces;
    }

    public CBegin(CBegin sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.version = sample.getVersion();
        this.access = sample.getAccess();
        this.name = sample.getName();
        this.signature = sample.getSignature();
        this.superName = sample.getSuperName();
        if (sample.interfaces != null) {
            this.interfaces = Arrays.copyOf(sample.interfaces, sample.interfaces.length);
        }
        this.source = sample.source != null ? sample.source.clone() : null;
        this.outerClass = sample.outerClass != null ? sample.outerClass.clone() : null;
        this.nestHost = sample.nestHost != null ? sample.nestHost.clone() : null;
        CPermittedSubclass cPermittedSubclass = this.permittedSubclass = sample.permittedSubclass != null ? sample.permittedSubclass.clone() : null;
        if (sample.annotations != null) {
            this.annotations = new ArrayList<CAnnotation>();
            for (CAnnotation cAnnotation : sample.annotations) {
                this.annotations.add(cAnnotation != null ? cAnnotation.clone() : null);
            }
        }
        if (sample.typeAnnotations != null) {
            this.typeAnnotations = new ArrayList<CTypeAnnotation>();
            for (CTypeAnnotation cTypeAnnotation : sample.typeAnnotations) {
                this.typeAnnotations.add(cTypeAnnotation != null ? cTypeAnnotation.clone() : null);
            }
        }
        if (sample.nestMembers != null) {
            this.nestMembers = new ArrayList<CNestMember>();
            for (CNestMember cNestMember : sample.nestMembers) {
                this.nestMembers.add(cNestMember != null ? cNestMember.clone() : null);
            }
        }
        if (sample.innerClasses != null) {
            this.innerClasses = new ArrayList<CInnerClass>();
            for (CInnerClass cInnerClass : sample.innerClasses) {
                this.innerClasses.add(cInnerClass != null ? cInnerClass.clone() : null);
            }
        }
        if (sample.fields != null) {
            this.fields = new ArrayList<CField>();
            for (CField cField : sample.fields) {
                this.fields.add(cField != null ? cField.clone() : null);
            }
        }
        if (sample.methods != null) {
            this.methods = new ArrayList<CMethod>();
            for (CMethod cMethod : sample.methods) {
                this.methods.add(cMethod != null ? cMethod.clone() : null);
            }
        }
        if (sample.order != null) {
            this.order = new LinkedHashMap<ClsByteCode, Integer>();
            this.order.putAll(sample.order);
        }
    }

    @Override
    public CBegin clone() {
        return new CBegin(this);
    }

    public CBegin configure(Consumer<CBegin> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(int access) {
        this.access = access;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JavaNamed javaName() {
        return new JavaNamed(this);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSuperName() {
        return this.superName;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public CSource getSource() {
        return this.source;
    }

    public void setSource(CSource s) {
        this.source = s;
    }

    public COuterClass getOuterClass() {
        return this.outerClass;
    }

    public void setOuterClass(COuterClass s) {
        this.outerClass = s;
    }

    public CNestHost getNestHost() {
        return this.nestHost;
    }

    public void setNestHost(CNestHost s) {
        this.nestHost = s;
    }

    public CPermittedSubclass getPermittedSubclass() {
        return this.permittedSubclass;
    }

    public void setPermittedSubclass(CPermittedSubclass s) {
        this.permittedSubclass = s;
    }

    public List<CAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<CAnnotation>();
        }
        return this.annotations;
    }

    public void setAnnotations(List<CAnnotation> ls) {
        this.annotations = ls;
    }

    public List<CTypeAnnotation> getTypeAnnotations() {
        if (this.typeAnnotations == null) {
            this.typeAnnotations = new ArrayList<CTypeAnnotation>();
        }
        return this.typeAnnotations;
    }

    public void setTypeAnnotations(List<CTypeAnnotation> ls) {
        this.typeAnnotations = ls;
    }

    public List<CNestMember> getNestMembers() {
        if (this.nestMembers == null) {
            this.nestMembers = new ArrayList<CNestMember>();
        }
        return this.nestMembers;
    }

    public void setNestMembers(List<CNestMember> ls) {
        this.nestMembers = ls;
    }

    public List<CInnerClass> getInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = new ArrayList<CInnerClass>();
        }
        return this.innerClasses;
    }

    public void setInnerClasses(List<CInnerClass> ls) {
        this.innerClasses = ls;
    }

    public List<CField> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<CField>();
        }
        return this.fields;
    }

    public void setFields(List<CField> fields) {
        this.fields = fields;
    }

    public List<CMethod> getMethods() {
        if (this.methods == null) {
            this.methods = new ArrayList<CMethod>();
        }
        return this.methods;
    }

    public void setMethods(List<CMethod> methods) {
        this.methods = methods;
    }

    public Map<ClsByteCode, Integer> getOrder() {
        if (this.order == null) {
            this.order = new LinkedHashMap<ClsByteCode, Integer>();
        }
        return this.order;
    }

    public void setOrder(Map<ClsByteCode, Integer> order) {
        this.order = order;
    }

    public CBegin order(ClsByteCode c, int order) {
        if (c == null) {
            throw new IllegalArgumentException("c==null");
        }
        this.getOrder().put(c, order);
        return this;
    }

    public String toString() {
        return CBegin.class.getSimpleName() + " version=" + this.version + " access=" + this.access + "#" + new AccFlags(this.access).flags() + " name=" + this.name + " signature=" + this.signature + " superName=" + this.superName + " interfaces=" + Arrays.toString(this.interfaces);
    }

    @Override
    public Eterable<ByteCode> nodes() {
        Eterable e = Eterable.of((Object[])new ByteCode[]{this.source, this.outerClass, this.nestHost, this.permittedSubclass});
        if (this.annotations != null && !this.annotations.isEmpty()) {
            e = e.union(new Iterable[]{Eterable.of(this.annotations)});
        }
        if (this.typeAnnotations != null && !this.typeAnnotations.isEmpty()) {
            e = e.union(new Iterable[]{Eterable.of(this.typeAnnotations)});
        }
        if (this.nestMembers != null && !this.nestMembers.isEmpty()) {
            e = e.union(new Iterable[]{Eterable.of(this.nestMembers)});
        }
        if (this.innerClasses != null && !this.innerClasses.isEmpty()) {
            e = e.union(new Iterable[]{Eterable.of(this.innerClasses)});
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            e = e.union(new Iterable[]{Eterable.of(this.fields)});
        }
        if (this.methods != null && !this.methods.isEmpty()) {
            e = e.union(new Iterable[]{Eterable.of(this.methods)});
        }
        return e.notNull();
    }

    @Override
    public void write(ClassWriter v) {
        COuterClass oc;
        CPermittedSubclass pss;
        CNestHost nh;
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        v.visit(this.getVersion(), this.getAccess(), this.getName(), this.getSignature(), this.getSuperName(), this.getInterfaces());
        CSource src = this.source;
        if (src != null) {
            src.write(v);
        }
        if ((nh = this.nestHost) != null) {
            nh.write(v);
        }
        if ((pss = this.permittedSubclass) != null) {
            pss.write(v);
        }
        if ((oc = this.outerClass) != null) {
            oc.write(v);
        }
        ArrayList<ClsByteCode> anns = new ArrayList<ClsByteCode>();
        if (this.annotations != null) {
            anns.addAll(this.annotations);
        }
        if (this.typeAnnotations != null) {
            anns.addAll(this.typeAnnotations);
        }
        anns.sort((a, b) -> {
            int o2;
            int o1 = this.getOrder().getOrDefault(a, -1);
            if (o1 == (o2 = this.getOrder().getOrDefault(b, -1).intValue())) {
                return a.toString().compareTo(b.toString());
            }
            return Integer.compare(o1, o2);
        });
        for (ClsByteCode ann : anns) {
            ann.write(v);
        }
        ArrayList<ClsByteCode> body = new ArrayList<ClsByteCode>();
        if (this.fields != null) {
            body.addAll(this.fields);
        }
        if (this.methods != null) {
            body.addAll(this.methods);
        }
        if (this.nestMembers != null) {
            body.addAll(this.nestMembers);
        }
        if (this.innerClasses != null) {
            body.addAll(this.innerClasses);
        }
        body.sort((a, b) -> {
            int o2;
            int o1 = this.getOrder().getOrDefault(a, -1);
            if (o1 == (o2 = this.getOrder().getOrDefault(b, -1).intValue())) {
                return a.toString().compareTo(b.toString());
            }
            return Integer.compare(o1, o2);
        });
        for (ClsByteCode b2 : body) {
            b2.write(v);
        }
        v.visitEnd();
    }

    public byte[] toByteCode() {
        ClassWriter cw = new ClassWriter(3);
        this.write(cw);
        return cw.toByteArray();
    }

    public static CBegin parseByteCode(byte[] byteCode) {
        if (byteCode == null) {
            throw new IllegalArgumentException("byteCode==null");
        }
        ClassReader classReader = new ClassReader(byteCode);
        ArrayList byteCodes = new ArrayList();
        ClassDump dump = new ClassDump();
        dump.byteCode(byteCodes::add);
        classReader.accept((ClassVisitor)dump, 0);
        return byteCodes.stream().filter(b -> b instanceof CBegin).map(b -> (CBegin)b).findFirst().get();
    }

    public static CBegin parseByteCode(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz==null");
        }
        String resName = "/" + clazz.getName().replace(".", "/") + ".class";
        URL classUrl = clazz.getResource(resName);
        if (classUrl == null) {
            throw new IOError(new IOException("resource " + resName + " not found"));
        }
        return CBegin.parseByteCode(classUrl);
    }

    public static CBegin parseByteCode(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        try {
            return CBegin.parseByteCode(IOFun.readBytes((URL)url));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static class JavaNamed {
        public final CBegin cBegin;

        public JavaNamed(CBegin cBegin) {
            if (cBegin == null) {
                throw new IllegalArgumentException("cBegin==null");
            }
            this.cBegin = cBegin;
        }

        public String getName() {
            String n = this.cBegin.getName();
            if (n == null) {
                return null;
            }
            return new JavaClassName((String)n).name;
        }

        public void setName(String name) {
            if (name == null) {
                this.cBegin.setName(null);
            } else {
                this.cBegin.setName(new JavaClassName(name).rawName());
            }
        }

        public String getSimpleName() {
            String n = this.cBegin.getName();
            if (n == null) {
                return null;
            }
            return new JavaClassName((String)n).simpleName;
        }

        public void setSimpleName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            if (!JavaClassName.validId.matcher(name).matches()) {
                throw new IllegalArgumentException("name not match " + JavaClassName.validId);
            }
            String curName = this.cBegin.getName();
            if (curName == null) {
                this.cBegin.setName(name);
                return;
            }
            this.cBegin.setName(new JavaClassName(curName).withSimpleName(name).rawName());
        }

        public String getPackage() {
            String n = this.cBegin.getName();
            if (n == null) {
                return "";
            }
            return new JavaClassName((String)n).packageName;
        }

        public void setPackage(String name) {
            if (name == null || name.length() < 1) {
                String n = this.cBegin.getName();
                if (n != null) {
                    this.cBegin.setName(new JavaClassName(n).withPackage("").rawName());
                }
            } else {
                String n = this.cBegin.getName();
                if (n == null) {
                    this.cBegin.setName(new JavaClassName("Class0").withPackage(name).rawName());
                } else {
                    this.cBegin.setName(new JavaClassName(n).withPackage(name).rawName());
                }
            }
        }

        public String toString() {
            String n = this.cBegin.getName();
            if (n == null) {
                return "null?";
            }
            return new JavaClassName((String)n).name;
        }
    }
}

