/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.sec;

import java.util.ArrayList;
import xyz.cofe.trambda.sec.TypeDesc;

public class MethodDescTypes {
    public final TypeDesc[] params;
    public final TypeDesc returns;
    public static final MethodDescTypes undefined = new MethodDescTypes(new TypeDesc[0], new TypeDesc("?"));

    public MethodDescTypes(TypeDesc[] params, TypeDesc returns) {
        if (params == null) {
            throw new IllegalArgumentException("params==null");
        }
        if (returns == null) {
            throw new IllegalArgumentException("returns==null");
        }
        this.params = params;
        this.returns = returns;
    }

    public static MethodDescTypes parse(String desc) {
        if (desc == null) {
            throw new IllegalArgumentException("desc==null");
        }
        if (!desc.startsWith("(")) {
            throw new IllegalArgumentException("desc not start with '('");
        }
        if (desc.length() < 2) {
            throw new IllegalArgumentException("desc length < 2");
        }
        ArrayList<TypeDesc> params = new ArrayList<TypeDesc>();
        int ptr = 1;
        if (!desc.startsWith("()")) {
            TypeDesc.Parse p;
            do {
                p = TypeDesc.parse(desc, ptr);
                if (p.to <= ptr) {
                    throw new IllegalStateException("!!");
                }
                params.add(p.type);
            } while ((ptr = p.to) < desc.length() && desc.charAt(ptr) != ')');
        } else {
            ptr = 1;
        }
        TypeDesc ret = null;
        if (++ptr >= desc.length()) {
            throw new IllegalStateException("can't parse return type");
        }
        TypeDesc.Parse p = TypeDesc.parse(desc, ptr);
        ret = p.type;
        return new MethodDescTypes(params.toArray(new TypeDesc[0]), ret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int pi = -1;
        for (TypeDesc p : this.params) {
            if (++pi > 0) {
                sb.append(", ");
            }
            sb.append(p);
        }
        sb.append(")");
        sb.append(" ").append(this.returns);
        return sb.toString();
    }
}

