/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.sec;

import java.util.ArrayList;
import java.util.List;
import xyz.cofe.fn.Tuple2;
import xyz.cofe.trambda.LambdaDump;
import xyz.cofe.trambda.LambdaNode;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.cls.CMethod;
import xyz.cofe.trambda.bc.mth.MInvokeDynamicInsn;
import xyz.cofe.trambda.bc.mth.MMethodInsn;
import xyz.cofe.trambda.bc.mth.MethodByteCode;
import xyz.cofe.trambda.sec.InvokeDynamicCall;
import xyz.cofe.trambda.sec.InvokeMethod;
import xyz.cofe.trambda.sec.MethodDescTypes;
import xyz.cofe.trambda.sec.SecurAccess;

public abstract class Invoke<INSTR extends ByteCode>
extends SecurAccess<INSTR, Tuple2<LambdaDump, LambdaNode>> {
    public Invoke(INSTR instr, Tuple2<LambdaDump, LambdaNode> dump) {
        super(instr, dump);
    }

    public static List<Invoke<?>> inspectCall(LambdaDump dump) {
        if (dump == null) {
            throw new IllegalArgumentException("dump==null");
        }
        ArrayList result = new ArrayList();
        Invoke.inspectCall(result, dump);
        return result;
    }

    private static void inspectCall(List<Invoke<?>> result, LambdaDump dump) {
        if (result == null) {
            throw new IllegalArgumentException("result==null");
        }
        if (dump == null) {
            throw new IllegalArgumentException("dump==null");
        }
        LambdaNode lnode = dump.getLambdaNode();
        if (lnode == null) {
            throw new IllegalArgumentException("dump.getLambdaNode()==null");
        }
        lnode.walk().tree().forEach(t -> {
            List<MethodByteCode> byteCodes;
            LambdaNode node = (LambdaNode)t.getNode();
            CMethod meth = node.getMethod();
            List<MethodByteCode> list = byteCodes = meth != null ? meth.getMethodByteCodes() : null;
            if (byteCodes != null) {
                for (MethodByteCode bc : byteCodes) {
                    if (bc == null) continue;
                    if (bc instanceof MInvokeDynamicInsn) {
                        result.add(new InvokeDynamicCall((MInvokeDynamicInsn)bc, (Tuple2<LambdaDump, LambdaNode>)Tuple2.of((Object)dump, (Object)node)));
                        continue;
                    }
                    if (!(bc instanceof MMethodInsn)) continue;
                    result.add(new InvokeMethod((MMethodInsn)bc, (Tuple2<LambdaDump, LambdaNode>)Tuple2.of((Object)dump, (Object)node)));
                }
            }
        });
    }

    public abstract String getOwner();

    public abstract String getMethodName();

    public abstract MethodDescTypes getMethodTypes();
}

