/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import xyz.cofe.trambda.bc.bm.MHandle;

public class MethodWriterCtx {
    private Map<String, Label> labels = new LinkedHashMap<String, Label>();

    public Label labelCreate(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (this.labels.containsKey(name)) {
            throw new IllegalArgumentException("label " + name + " already defined");
        }
        Label lbl = new Label();
        this.labels.put(name, lbl);
        return lbl;
    }

    public Label labelGet(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (!this.labels.containsKey(name)) {
            throw new IllegalArgumentException("label " + name + " not found");
        }
        return this.labels.get(name);
    }

    public Label labelCreateOrGet(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (this.labels.containsKey(name)) {
            return this.labels.get(name);
        }
        return this.labelCreate(name);
    }

    public Label[] labelsGet(String ... names) {
        if (names == null) {
            return null;
        }
        Label[] res = new Label[names.length];
        for (int i = 0; i < names.length; ++i) {
            res[i] = names[i] != null ? this.labelGet(names[i]) : null;
        }
        return res;
    }

    public Handle bootstrapArgument(MHandle targetCallArg, Handle bootstrap) {
        if (targetCallArg == null) {
            throw new IllegalArgumentException("targetCallArg==null");
        }
        String name = targetCallArg.getName();
        String owner = targetCallArg.getOwner();
        Handle h = new Handle(targetCallArg.getTag(), owner, name, targetCallArg.getDesc(), targetCallArg.isIface());
        return h;
    }
}

