/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MFrame
extends MAbstractBC
implements MethodWriter {
    private int type;
    private int numLocal;
    private List<Object> local;
    private int numStack;
    private List<Object> stack;

    public MFrame() {
    }

    public MFrame(int type, int numLocal, List<Object> local, int numStack, List<Object> stack) {
        this.type = type;
        this.numLocal = numLocal;
        this.local = local;
        this.numStack = numStack;
        this.stack = stack;
    }

    public MFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        this.type = type;
        this.numLocal = numLocal;
        Function<Object[], List> init = arr -> {
            if (arr == null) {
                return null;
            }
            ArrayList<Object> res = new ArrayList<Object>();
            for (Object l : arr) {
                if (l == null) {
                    res.add(null);
                    continue;
                }
                if (l instanceof Serializable) {
                    res.add(l);
                    continue;
                }
                throw new IllegalArgumentException("not serializable");
            }
            return res;
        };
        this.local = init.apply(local);
        this.numStack = numStack;
        this.stack = init.apply(stack);
    }

    public MFrame(MFrame sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.type = sample.getType();
        this.numLocal = sample.getNumLocal();
        if (sample.local != null) {
            this.local = new ArrayList<Object>(sample.local);
        }
        if (sample.stack != null) {
            this.stack = new ArrayList<Object>(sample.stack);
        }
    }

    @Override
    public MFrame clone() {
        return new MFrame(this);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getNumLocal() {
        return this.numLocal;
    }

    public void setNumLocal(int numLocal) {
        this.numLocal = numLocal;
    }

    public List<Object> getLocal() {
        return this.local;
    }

    public void setLocal(List<Object> local) {
        this.local = local;
    }

    public int getNumStack() {
        return this.numStack;
    }

    public void setNumStack(int numStack) {
        this.numStack = numStack;
    }

    public List<Object> getStack() {
        return this.stack;
    }

    public void setStack(List<Object> stack) {
        this.stack = stack;
    }

    public String toString() {
        return MFrame.class.getSimpleName() + " type=" + this.type + " numLocal=" + this.numLocal + " local=" + (this.local == null ? "null" : this.local) + " numStack=" + this.numStack + ", stack=" + (this.stack == null ? "null" : this.stack);
    }

    @Override
    public void write(MethodVisitor mv, MethodWriterCtx ctx) {
        Object[] stack;
        Object[] local;
        if (mv == null) {
            throw new IllegalArgumentException("mv==null");
        }
        Object[] objectArray = local = this.getLocal() == null ? null : new Object[this.getLocal().size()];
        if (local != null) {
            for (int i = 0; i < local.length; ++i) {
                local[i] = this.getLocal().get(i);
            }
        }
        Object[] objectArray2 = stack = this.getStack() == null ? null : new Object[this.getStack().size()];
        if (stack != null) {
            for (int i = 0; i < stack.length; ++i) {
                stack[i] = this.getStack().get(i);
            }
        }
        mv.visitFrame(this.getType(), this.getNumLocal(), local, this.getNumStack(), stack);
    }
}

