/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;
import xyz.cofe.trambda.bc.mth.OpCode;

public class MFieldInsn
extends MAbstractBC
implements MethodWriter {
    private static final long serialVersionUID = 1L;
    private int opcode;
    private String owner;
    private String name;
    private String descriptor;

    public MFieldInsn() {
    }

    public MFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.opcode = opcode;
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
    }

    public MFieldInsn(MFieldInsn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.opcode = sample.getOpcode();
        this.owner = sample.getOwner();
        this.name = sample.getName();
        this.descriptor = sample.getDescriptor();
    }

    @Override
    public MFieldInsn clone() {
        return new MFieldInsn(this);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String toString() {
        return MFieldInsn.class.getSimpleName() + " opcode=" + OpCode.code(this.opcode).map(Enum::name).orElse("?") + "#" + this.opcode + " owner='" + this.owner + "' name='" + this.name + "' descriptor='" + this.descriptor + "'}";
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        v.visitFieldInsn(this.getOpcode(), this.getOwner(), this.getName(), this.getDescriptor());
    }
}

