/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.ann;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationWriter;
import xyz.cofe.trambda.bc.ann.EmbededAnnotation;

public class EmANameDesc
extends EmbededAnnotation
implements AnnotationWriter {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String descriptor;

    public EmANameDesc() {
    }

    public EmANameDesc(EmANameDesc sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.name = sample.getName();
        this.descriptor = sample.getDescriptor();
        if (sample.annotationByteCodes != null) {
            this.annotationByteCodes = new ArrayList();
            for (AnnotationByteCode b : sample.annotationByteCodes) {
                if (b != null) {
                    this.annotationByteCodes.add(b.clone());
                    continue;
                }
                this.annotationByteCodes.add(null);
            }
        }
    }

    @Override
    public EmANameDesc clone() {
        return new EmANameDesc(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String toString() {
        return EmANameDesc.class.getSimpleName() + " name=" + this.name + " descriptor=" + this.descriptor;
    }

    @Override
    public Eterable<ByteCode> nodes() {
        if (this.annotationByteCodes != null) {
            return Eterable.of((Iterable)this.annotationByteCodes);
        }
        return Eterable.empty();
    }

    @Override
    public void write(AnnotationVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        AnnotationVisitor nv = v.visitAnnotation(this.getName(), this.getDescriptor());
        List body = this.annotationByteCodes;
        if (body != null) {
            for (AnnotationByteCode b : body) {
                if (!(b instanceof AnnotationWriter)) continue;
                b.write(nv);
            }
        }
    }
}

