/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import xyz.cofe.trambda.AnnotationDump;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.bm.LdcType;
import xyz.cofe.trambda.bc.bm.MHandle;
import xyz.cofe.trambda.bc.mth.MAnnotableParameterCount;
import xyz.cofe.trambda.bc.mth.MAnnotation;
import xyz.cofe.trambda.bc.mth.MAnnotationDefault;
import xyz.cofe.trambda.bc.mth.MCode;
import xyz.cofe.trambda.bc.mth.MEnd;
import xyz.cofe.trambda.bc.mth.MFieldInsn;
import xyz.cofe.trambda.bc.mth.MFrame;
import xyz.cofe.trambda.bc.mth.MIincInsn;
import xyz.cofe.trambda.bc.mth.MInsn;
import xyz.cofe.trambda.bc.mth.MInsnAnnotation;
import xyz.cofe.trambda.bc.mth.MIntInsn;
import xyz.cofe.trambda.bc.mth.MInvokeDynamicInsn;
import xyz.cofe.trambda.bc.mth.MJumpInsn;
import xyz.cofe.trambda.bc.mth.MLabel;
import xyz.cofe.trambda.bc.mth.MLdcInsn;
import xyz.cofe.trambda.bc.mth.MLineNumber;
import xyz.cofe.trambda.bc.mth.MLocalVariable;
import xyz.cofe.trambda.bc.mth.MLocalVariableAnnotation;
import xyz.cofe.trambda.bc.mth.MLookupSwitchInsn;
import xyz.cofe.trambda.bc.mth.MMaxs;
import xyz.cofe.trambda.bc.mth.MMethodInsn;
import xyz.cofe.trambda.bc.mth.MMultiANewArrayInsn;
import xyz.cofe.trambda.bc.mth.MParameter;
import xyz.cofe.trambda.bc.mth.MParameterAnnotation;
import xyz.cofe.trambda.bc.mth.MTableSwitchInsn;
import xyz.cofe.trambda.bc.mth.MTryCatchAnnotation;
import xyz.cofe.trambda.bc.mth.MTryCatchBlock;
import xyz.cofe.trambda.bc.mth.MTypeAnnotation;
import xyz.cofe.trambda.bc.mth.MTypeInsn;
import xyz.cofe.trambda.bc.mth.MVarInsn;

public class MethodDump
extends MethodVisitor
implements Opcodes {
    private Consumer<? super ByteCode> byteCodeConsumer;

    private void dump(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (args == null || args.length == 0) {
            System.out.println(message);
        } else {
            System.out.print(message);
            for (Object a : args) {
                System.out.print(" ");
                System.out.print(a);
            }
            System.out.println();
        }
    }

    public MethodDump byteCode(Consumer<? super ByteCode> bc) {
        this.byteCodeConsumer = bc;
        return this;
    }

    protected void emit(ByteCode bc) {
        if (bc == null) {
            throw new IllegalArgumentException("bc==null");
        }
        Consumer<? super ByteCode> c = this.byteCodeConsumer;
        if (c != null) {
            c.accept(bc);
        }
    }

    public MethodDump(int api) {
        super(api);
    }

    public MethodDump(int api, MethodVisitor methodVisitor) {
        super(api, methodVisitor);
    }

    public void visitParameter(String name, int access) {
        this.emit(new MParameter(name, access));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        MAnnotationDefault bc = new MAnnotationDefault();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, bc);
        this.emit(bc);
        return dump;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        MAnnotation ann = new MAnnotation(descriptor, visible);
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, ann);
        this.emit(ann);
        return dump;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        MTypeAnnotation ta = new MTypeAnnotation();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, ta);
        ta.setTypeRef(typeRef);
        ta.setTypePath(typePath != null ? typePath.toString() : null);
        ta.setDescriptor(descriptor);
        ta.setVisible(visible);
        this.emit(ta);
        return dump;
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.emit(new MAnnotableParameterCount(parameterCount, visible));
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        MParameterAnnotation pa = new MParameterAnnotation();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, pa);
        pa.setParameter(parameter);
        pa.setDescriptor(descriptor);
        pa.setVisible(visible);
        this.emit(pa);
        return dump;
    }

    public void visitAttribute(Attribute attribute) {
        this.dump("Attribute", attribute);
        super.visitAttribute(attribute);
    }

    public void visitCode() {
        this.emit(new MCode());
    }

    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        this.emit(new MFrame(type, numLocal, local, numStack, stack));
    }

    public void visitInsn(int opcode) {
        this.emit(new MInsn(opcode));
    }

    public void visitIntInsn(int opcode, int operand) {
        this.emit(new MIntInsn(opcode, operand));
    }

    public void visitVarInsn(int opcode, int var) {
        this.emit(new MVarInsn(opcode, var));
    }

    public void visitTypeInsn(int opcode, String type) {
        this.emit(new MTypeInsn(opcode, type));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.emit(new MFieldInsn(opcode, owner, name, descriptor));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.emit(new MMethodInsn(opcode, owner, name, descriptor, isInterface));
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.emit(new MInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments));
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.emit(new MJumpInsn(opcode, label != null ? label.toString() : null));
    }

    public void visitLabel(Label label) {
        this.emit(new MLabel(label.toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitLdcInsn(Object value) {
        if (value instanceof Integer) {
            this.emit(new MLdcInsn(value, LdcType.Integer));
            return;
        } else if (value instanceof Float) {
            this.emit(new MLdcInsn(value, LdcType.Float));
            return;
        } else if (value instanceof Long) {
            this.emit(new MLdcInsn(value, LdcType.Long));
            return;
        } else if (value instanceof Double) {
            this.emit(new MLdcInsn(value, LdcType.Double));
            return;
        } else if (value instanceof String) {
            this.emit(new MLdcInsn(value, LdcType.String));
            return;
        } else if (value instanceof Type) {
            Type tvalue = (Type)value;
            int sort = tvalue.getSort();
            if (sort == 10) {
                this.emit(new MLdcInsn(tvalue.getDescriptor(), LdcType.Object));
                return;
            } else if (sort == 9) {
                this.emit(new MLdcInsn(tvalue.getDescriptor(), LdcType.Array));
                return;
            } else {
                if (sort != 11) throw new UnsupportedOperationException("unsupported ldc sort=" + sort);
                this.emit(new MLdcInsn(tvalue.getDescriptor(), LdcType.Method));
            }
            return;
        } else if (value instanceof Handle) {
            Handle hdl = (Handle)value;
            MHandle hdl0 = new MHandle(hdl);
            this.emit(new MLdcInsn(hdl0, LdcType.Handle));
            return;
        } else {
            if (!(value instanceof ConstantDynamic)) throw new UnsupportedOperationException("unsupported ldc of " + value);
            throw new UnsupportedOperationException("not impl ldc ConstantDynamic");
        }
    }

    public void visitIincInsn(int var, int increment) {
        this.emit(new MIincInsn(var, increment));
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        String defLbl = dflt != null ? dflt.toString() : null;
        String[] lbls = labels != null ? (String[])List.of(labels).stream().map(l -> l != null ? l.toString() : null).toArray(String[]::new) : null;
        this.emit(new MTableSwitchInsn(min, max, defLbl, lbls));
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        String defLbl = dflt != null ? dflt.toString() : null;
        String[] lbls = labels != null ? (String[])List.of(labels).stream().map(l -> l != null ? l.toString() : null).toArray(String[]::new) : null;
        this.emit(new MLookupSwitchInsn(defLbl, keys, lbls));
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.emit(new MMultiANewArrayInsn(descriptor, numDimensions));
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        MInsnAnnotation ia = new MInsnAnnotation();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, ia);
        ia.setTypeRef(typeRef);
        ia.setTypePath(typePath != null ? typePath.toString() : null);
        ia.setDescriptor(descriptor);
        ia.setVisible(visible);
        this.emit(ia);
        return dump;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.emit(new MTryCatchBlock(start != null ? start.toString() : null, end != null ? end.toString() : null, handler != null ? handler.toString() : null, type));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        MTryCatchAnnotation a = new MTryCatchAnnotation(typeRef, typePath != null ? typePath.toString() : null, descriptor, visible);
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, a);
        this.emit(a);
        return dump;
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        this.emit(new MLocalVariable(name, descriptor, signature, start != null ? start.toString() : null, end != null ? end.toString() : null, index));
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        MLocalVariableAnnotation a = new MLocalVariableAnnotation();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, a);
        a.setTypeRef(typeRef);
        a.setTypePath(typePath != null ? typePath.toString() : null);
        if (start != null) {
            a.setStartLabels((String[])Arrays.stream(start).map(s -> s != null ? s.toString() : null).toArray(String[]::new));
        }
        if (end != null) {
            a.setEndLabels((String[])Arrays.stream(end).map(s -> s != null ? s.toString() : null).toArray(String[]::new));
        }
        a.setIndex(index);
        a.setDescriptor(descriptor);
        a.setVisible(visible);
        this.emit(a);
        return dump;
    }

    public void visitLineNumber(int line, Label start) {
        this.emit(new MLineNumber(line, start.toString()));
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.emit(new MMaxs(maxStack, maxLocals));
    }

    public void visitEnd() {
        this.emit(new MEnd());
    }
}

