/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.TypePath;
import xyz.cofe.trambda.AnnotationDump;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.fld.FAnnotation;
import xyz.cofe.trambda.bc.fld.FTypeAnnotation;
import xyz.cofe.trambda.bc.fld.FieldByteCode;
import xyz.cofe.trambda.bc.fld.FieldEnd;

public class FieldDump
extends FieldVisitor {
    private Consumer<? super ByteCode> byteCodeConsumer;
    public static final AtomicInteger idSeq = new AtomicInteger(0);

    private void dump(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (args == null || args.length == 0) {
            System.out.println(message);
        } else {
            System.out.print(message);
            for (Object a : args) {
                System.out.print(" ");
                System.out.print(a);
            }
            System.out.println();
        }
    }

    public FieldDump(int api) {
        super(api);
    }

    public FieldDump(int api, FieldVisitor fieldVisitor) {
        super(api, fieldVisitor);
    }

    public FieldDump byteCode(Consumer<? super ByteCode> bc) {
        this.byteCodeConsumer = bc;
        return this;
    }

    protected void emit(FieldByteCode bc) {
        if (bc == null) {
            throw new IllegalArgumentException("bc==null");
        }
        Consumer<? super ByteCode> c = this.byteCodeConsumer;
        if (c != null) {
            c.accept(bc);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationDump dump = new AnnotationDump(this.api);
        FAnnotation a = new FAnnotation(descriptor, visible);
        dump.byteCode(this.byteCodeConsumer, a);
        this.emit(a);
        return dump;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationDump dump = new AnnotationDump(this.api);
        FTypeAnnotation ta = new FTypeAnnotation();
        dump.byteCode(this.byteCodeConsumer, ta);
        ta.setTypeRef(typeRef);
        ta.setTypePath(typePath != null ? typePath.toString() : null);
        ta.setDescriptor(descriptor);
        ta.setVisible(visible);
        this.emit(ta);
        return dump;
    }

    public void visitAttribute(Attribute attribute) {
        this.dump("visitAttribute ", attribute);
        super.visitAttribute(attribute);
    }

    public void visitEnd() {
        this.emit(new FieldEnd());
    }
}

