/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import xyz.cofe.trambda.bc.bm.BootstrapMethArg;
import xyz.cofe.trambda.bc.bm.LdcType;
import xyz.cofe.trambda.bc.bm.MHandle;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MLdcInsn
extends MAbstractBC
implements MethodWriter {
    private LdcType ldcType;
    private Object value;

    public MLdcInsn() {
    }

    public MLdcInsn(Object value, LdcType ldcType) {
        this.value = value;
        this.ldcType = ldcType;
    }

    public MLdcInsn(MLdcInsn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.ldcType = sample.getLdcType();
        this.value = sample.value instanceof BootstrapMethArg ? ((BootstrapMethArg)sample.value).clone() : sample.value;
    }

    @Override
    public MLdcInsn clone() {
        return new MLdcInsn(this);
    }

    public LdcType getLdcType() {
        return this.ldcType;
    }

    public void setLdcType(LdcType ldcType) {
        this.ldcType = ldcType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return MLdcInsn.class.getSimpleName() + " ldcType=" + this.ldcType + " value=" + this.value;
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        switch (this.getLdcType()) {
            case Long: {
                v.visitLdcInsn((Object)((Long)this.getValue()));
                break;
            }
            case Integer: {
                v.visitLdcInsn((Object)((Integer)this.getValue()));
                break;
            }
            case Double: {
                v.visitLdcInsn((Object)((Double)this.getValue()));
                break;
            }
            case String: {
                v.visitLdcInsn((Object)((String)this.getValue()));
                break;
            }
            case Float: {
                v.visitLdcInsn((Object)((Float)this.getValue()));
                break;
            }
            case Handle: {
                MHandle hdl1 = (MHandle)this.getValue();
                Handle hdl0 = new Handle(hdl1.getTag(), hdl1.getOwner(), hdl1.getName(), hdl1.getDesc(), hdl1.isIface());
                v.visitLdcInsn((Object)hdl0);
                break;
            }
            case Array: 
            case Method: 
            case Object: {
                if (this.value == null) {
                    throw new IllegalStateException("value is null");
                }
                if (this.value instanceof Type) {
                    v.visitLdcInsn(this.value);
                    break;
                }
                v.visitLdcInsn((Object)Type.getType((String)this.value.toString()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("not impl for ldc type = " + this.getLdcType());
            }
        }
    }
}

