/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;
import xyz.cofe.trambda.bc.mth.OpCode;

public class MJumpInsn
extends MAbstractBC
implements MethodWriter {
    private static final long serialVersionUID = 1L;
    private int opcode;
    private String label;

    public MJumpInsn() {
    }

    public MJumpInsn(int op, String label) {
        this.opcode = op;
        this.label = label;
    }

    public MJumpInsn(MJumpInsn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.opcode = sample.getOpcode();
        this.label = sample.getLabel();
    }

    @Override
    public MJumpInsn clone() {
        return new MJumpInsn(this);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return MJumpInsn.class.getSimpleName() + " opcode=" + OpCode.code(this.opcode).map(Enum::name).orElse("?") + "#" + this.opcode + " label=" + this.label;
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx==null");
        }
        v.visitJumpInsn(this.getOpcode(), ctx.labelCreateOrGet(this.getLabel()));
    }
}

