/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc;

import java.util.Optional;
import xyz.cofe.fn.Tuple2;

public class StringLiteral {
    public static String toStringLiteral(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\'') {
                sb.append("\\'");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c < ' ') {
                sb.append("\\x");
                int b = c & 0xFF;
                int lo = b & 0xF;
                int hi = (b & 0xF0) >> 4;
                sb.append("00").append(Integer.toHexString(hi)).append(Integer.toHexString(lo));
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c < '\u0100') {
                sb.append(c);
                continue;
            }
            char n = c;
            int b0 = (n & 0xFF00) >> 8;
            int b1 = n & 0xFF;
            int n0 = (b0 & 0xF0) >> 4;
            int n1 = b0 & 0xF;
            int n2 = (b1 & 0xF0) >> 4;
            int n3 = b1 & 0xF;
            sb.append("\\x");
            sb.append(Integer.toHexString(n0));
            sb.append(Integer.toHexString(n1));
            sb.append(Integer.toHexString(n2));
            sb.append(Integer.toHexString(n3));
        }
        sb.append("\"");
        return sb.toString();
    }

    public static Optional<Tuple2<String, Integer>> parse(String text, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset<0");
        }
        if (offset >= text.length()) {
            return Optional.empty();
        }
        String str = text.substring(offset);
        if (str.startsWith("null")) {
            return Optional.of(Tuple2.of(null, (Object)(offset + 4)));
        }
        if (!str.startsWith("\"")) {
            return Optional.empty();
        }
        StringBuilder sb = new StringBuilder();
        int ptr = 1;
        String state = "init";
        StringBuilder hex = new StringBuilder();
        while (ptr < str.length()) {
            char c0 = str.charAt(ptr);
            ++ptr;
            boolean stop = false;
            block8 : switch (state) {
                case "init": {
                    switch (c0) {
                        case '\"': {
                            stop = true;
                            break block8;
                        }
                        case '\\': {
                            state = "escape";
                            break block8;
                        }
                    }
                    sb.append(c0);
                    break;
                }
                case "escape": {
                    switch (c0) {
                        case 'n': {
                            state = "init";
                            sb.append("\n");
                            break block8;
                        }
                        case 'r': {
                            state = "init";
                            sb.append("\r");
                            break block8;
                        }
                        case 't': {
                            state = "init";
                            sb.append("\t");
                            break block8;
                        }
                        case 'x': {
                            state = "hex0";
                            hex.setLength(0);
                            break block8;
                        }
                    }
                    sb.append(c0);
                    state = "init";
                    break;
                }
                case "hex0": {
                    hex.append(c0);
                    state = "hex1";
                    break;
                }
                case "hex1": {
                    hex.append(c0);
                    state = "hex2";
                    break;
                }
                case "hex2": {
                    hex.append(c0);
                    state = "hex3";
                    break;
                }
                case "hex3": {
                    hex.append(c0);
                    state = "init";
                    int n = Integer.parseInt(hex.toString());
                    sb.append((char)n);
                }
            }
            if (!stop) continue;
            break;
        }
        int next = ptr + offset;
        return Optional.of(Tuple2.of((Object)sb.toString(), (Object)next));
    }
}

