/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda;

import java.util.Optional;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.TypePath;
import xyz.cofe.trambda.AnnotationDump;
import xyz.cofe.trambda.FieldDump;
import xyz.cofe.trambda.MethodDump;
import xyz.cofe.trambda.bc.AccFlags;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.cls.CAnnotation;
import xyz.cofe.trambda.bc.cls.CBegin;
import xyz.cofe.trambda.bc.cls.CEnd;
import xyz.cofe.trambda.bc.cls.CField;
import xyz.cofe.trambda.bc.cls.CInnerClass;
import xyz.cofe.trambda.bc.cls.CMethod;
import xyz.cofe.trambda.bc.cls.CNestHost;
import xyz.cofe.trambda.bc.cls.CNestMember;
import xyz.cofe.trambda.bc.cls.COuterClass;
import xyz.cofe.trambda.bc.cls.CPermittedSubclass;
import xyz.cofe.trambda.bc.cls.CSource;
import xyz.cofe.trambda.bc.cls.CTypeAnnotation;
import xyz.cofe.trambda.bc.fld.FieldByteCode;
import xyz.cofe.trambda.bc.mth.MethodByteCode;

public class ClassDump
extends ClassVisitor {
    private Consumer<? super ByteCode> byteCodeConsumer;
    protected final ThreadLocal<CBegin> currentClass = new ThreadLocal();
    protected final ThreadLocal<Integer> currentIndex = new ThreadLocal();

    private void dump(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (args == null || args.length == 0) {
            System.out.println(message);
        } else {
            System.out.print(message);
            for (Object a : args) {
                System.out.print(" ");
                System.out.print(a);
            }
            System.out.println();
        }
    }

    public ClassDump(int api) {
        super(api);
    }

    public ClassDump() {
        super(589824);
    }

    public ClassDump byteCode(Consumer<? super ByteCode> bc) {
        this.byteCodeConsumer = bc;
        return this;
    }

    private void emit(ByteCode bc) {
        if (bc == null) {
            throw new IllegalArgumentException("bc==null");
        }
        Consumer<? super ByteCode> c = this.byteCodeConsumer;
        if (c != null) {
            c.accept(bc);
        }
    }

    protected Optional<CBegin> currentClass() {
        CBegin v = this.currentClass.get();
        return v != null ? Optional.of(v) : Optional.empty();
    }

    protected void currentClass(CBegin begin) {
        this.currentClass.set(begin);
    }

    protected void currentClass(Consumer<CBegin> c) {
        if (c == null) {
            throw new IllegalArgumentException("c==null");
        }
        CBegin v = this.currentClass.get();
        if (v == null) {
            throw new IllegalThreadStateException("current class not defined");
        }
        c.accept(v);
    }

    protected int currentIndex() {
        Integer i = this.currentIndex.get();
        if (i == null) {
            this.currentIndex.set(0);
            return 0;
        }
        return i;
    }

    protected int currentIndexGetAndInc() {
        Integer i = this.currentIndex.get();
        if (i == null) {
            this.currentIndex.set(1);
            return 0;
        }
        this.currentIndex.set(i + 1);
        return i;
    }

    protected void currentIndex(int i) {
        this.currentIndex.set(i);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        CBegin c = new CBegin(version, access, name, signature, superName, interfaces);
        this.currentClass(c);
        this.currentIndex(0);
        this.emit(c);
    }

    public void visitSource(String source, String debug) {
        int ci = this.currentIndexGetAndInc();
        CSource c = new CSource(source, debug);
        this.currentClass((CBegin x) -> {
            x.setSource(c);
            x.getOrder().put(c, ci);
        });
        this.emit(c);
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        this.dump("module name=" + name + " access=" + new AccFlags(access).flags() + " version=" + version, new Object[0]);
        return super.visitModule(name, access, version);
    }

    public void visitNestHost(String nestHost) {
        int ci = this.currentIndexGetAndInc();
        CNestHost c = new CNestHost(nestHost);
        this.currentClass((CBegin x) -> {
            x.setNestHost(c);
            x.getOrder().put(c, ci);
        });
        this.emit(new CNestHost(nestHost));
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
        int ci = this.currentIndexGetAndInc();
        COuterClass c = new COuterClass(owner, name, descriptor);
        this.currentClass((CBegin x) -> {
            x.setOuterClass(c);
            x.getOrder().put(c, ci);
        });
        this.emit(c);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        int ci = this.currentIndexGetAndInc();
        CAnnotation a = new CAnnotation(descriptor, visible);
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, a);
        this.currentClass((CBegin x) -> x.order(a, ci).getAnnotations().add(a));
        this.emit(a);
        return dump;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        int ci = this.currentIndexGetAndInc();
        CTypeAnnotation a = new CTypeAnnotation(typeRef, typePath != null ? typePath.toString() : null, descriptor, visible);
        AnnotationDump dump = new AnnotationDump(this.api);
        dump.byteCode(this.byteCodeConsumer, a);
        this.currentClass((CBegin x) -> x.order(a, ci).getTypeAnnotations().add(a));
        this.emit(a);
        return dump;
    }

    public void visitAttribute(Attribute attribute) {
        this.dump("ann " + attribute, new Object[0]);
    }

    public void visitNestMember(String nestMember) {
        int ci = this.currentIndexGetAndInc();
        CNestMember c = new CNestMember(nestMember);
        this.currentClass((CBegin x) -> x.order(c, ci).getNestMembers().add(c));
        this.emit(c);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        int ci = this.currentIndexGetAndInc();
        CPermittedSubclass c = new CPermittedSubclass(permittedSubclass);
        this.currentClass((CBegin x) -> x.order(c, ci).setPermittedSubclass(c));
        this.emit(c);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        int ci = this.currentIndexGetAndInc();
        CInnerClass c = new CInnerClass(name, outerName, innerName, access);
        this.currentClass((CBegin x) -> x.order(c, ci).getInnerClasses().add(c));
        this.emit(c);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.dump("recordComponent name=" + name + " descriptor=" + descriptor + " signature=" + signature, new Object[0]);
        return super.visitRecordComponent(name, descriptor, signature);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        int ci = this.currentIndexGetAndInc();
        CField c = new CField(access, name, descriptor, signature, value);
        FieldDump dump = new FieldDump(this.api);
        dump.byteCode(b -> {
            if (this.byteCodeConsumer != null) {
                this.byteCodeConsumer.accept((ByteCode)b);
            }
            if (b instanceof FieldByteCode) {
                c.getFieldByteCodes().add((FieldByteCode)b);
            }
        });
        this.currentClass((CBegin x) -> x.order(c, ci).getFields().add(c));
        this.emit(c);
        return dump;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        int ci = this.currentIndexGetAndInc();
        CMethod method = new CMethod(access, name, descriptor, signature, exceptions);
        MethodDump dump = new MethodDump(this.api);
        dump.byteCode(b -> {
            if (this.byteCodeConsumer != null) {
                this.byteCodeConsumer.accept((ByteCode)b);
            }
            if (b instanceof MethodByteCode) {
                method.getMethodByteCodes().add((MethodByteCode)b);
            }
        });
        this.emit(method);
        this.currentClass((CBegin x) -> x.order(method, ci).getMethods().add(method));
        return dump;
    }

    public void visitEnd() {
        this.emit(new CEnd());
    }
}

