/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.sec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import xyz.cofe.fn.Tuple2;
import xyz.cofe.trambda.LambdaDump;
import xyz.cofe.trambda.LambdaNode;
import xyz.cofe.trambda.sec.FieldAccess;
import xyz.cofe.trambda.sec.Invoke;
import xyz.cofe.trambda.sec.InvokeDynamicCall;
import xyz.cofe.trambda.sec.InvokeMethod;
import xyz.cofe.trambda.sec.SecurAccess;
import xyz.cofe.trambda.sec.SecurMessage;
import xyz.cofe.trambda.sec.SecurityFilter;

public class SecurityFilters<MESSAGE, SCOPE>
implements SecurityFilter<MESSAGE, SCOPE> {
    private final List<Function<SecurAccess<?, SCOPE>, Optional<Tuple2<MESSAGE, Boolean>>>> validators;

    public SecurityFilters(List<Function<SecurAccess<?, SCOPE>, Optional<Tuple2<MESSAGE, Boolean>>>> validators) {
        ArrayList validators00 = new ArrayList();
        if (validators != null) {
            validators00.addAll(validators);
        }
        this.validators = Collections.unmodifiableList(validators00);
    }

    @Override
    public List<SecurMessage<MESSAGE, SCOPE>> validate(List<SecurAccess<?, SCOPE>> secur) {
        if (secur == null) {
            throw new IllegalArgumentException("secur==null");
        }
        ArrayList<SecurMessage<MESSAGE, SCOPE>> res = new ArrayList<SecurMessage<MESSAGE, SCOPE>>();
        List<Function<SecurAccess<?, SCOPE>, Optional<Tuple2<MESSAGE, Boolean>>>> validtrs = this.validators;
        if (validtrs != null) {
            for (SecurAccess<?, SCOPE> sa : secur) {
                if (sa == null) continue;
                Object msg = null;
                Boolean allw = null;
                for (Function<SecurAccess<?, SCOPE>, Optional<Tuple2<MESSAGE, Boolean>>> vald : validtrs) {
                    Optional<Tuple2<MESSAGE, Boolean>> omsg;
                    if (vald == null || !(omsg = vald.apply(sa)).isPresent()) continue;
                    msg = omsg.get().a();
                    allw = (Boolean)omsg.get().b();
                    break;
                }
                if (msg == null) continue;
                res.add(new SecurMessage<Object, SCOPE>(sa, allw, msg));
            }
        }
        return res;
    }

    public static <MESSAGE, SCOPE> Builder<MESSAGE, SCOPE> create(Class<MESSAGE> cMsg, Class<SCOPE> cScope) {
        return new Builder();
    }

    public static Builder<String, Tuple2<LambdaDump, LambdaNode>> create() {
        return SecurityFilters.create(null, null);
    }

    public static SecurityFilters<String, Tuple2<LambdaDump, LambdaNode>> create(Consumer<Builder<String, Tuple2<LambdaDump, LambdaNode>>> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        Builder<String, Tuple2<LambdaDump, LambdaNode>> bld = SecurityFilters.create();
        conf.accept(bld);
        return bld.build();
    }

    public static class DenyBuilder<MESSAGE, SCOPE>
    extends PredicateBuilder<MESSAGE, SCOPE, DenyBuilder<MESSAGE, SCOPE>> {
        public DenyBuilder(Builder<MESSAGE, SCOPE> builder) {
            super(builder);
        }

        @Override
        protected void append(Function<SecurAccess<?, SCOPE>, Optional<MESSAGE>> filter) {
            this.builder.validators.add(ev -> {
                Optional res = (Optional)filter.apply((SecurAccess)ev);
                return res.map(message -> Tuple2.of((Object)message, (Object)false));
            });
        }
    }

    public static class AllowBuilder<MESSAGE, SCOPE>
    extends PredicateBuilder<MESSAGE, SCOPE, AllowBuilder<MESSAGE, SCOPE>> {
        public AllowBuilder(Builder<MESSAGE, SCOPE> builder) {
            super(builder);
        }

        @Override
        protected void append(Function<SecurAccess<?, SCOPE>, Optional<MESSAGE>> filter) {
            this.builder.validators.add(ev -> {
                Optional res = (Optional)filter.apply((SecurAccess)ev);
                return res.map(message -> Tuple2.of((Object)message, (Object)true));
            });
        }
    }

    public static abstract class PredicateBuilder<MESSAGE, SCOPE, SELF extends PredicateBuilder<MESSAGE, SCOPE, SELF>> {
        public final Builder<MESSAGE, SCOPE> builder;

        public PredicateBuilder(Builder<MESSAGE, SCOPE> builder) {
            this.builder = builder;
        }

        protected abstract void append(Function<SecurAccess<?, SCOPE>, Optional<MESSAGE>> var1);

        public Builder<MESSAGE, SCOPE> any(MESSAGE message) {
            this.append(t -> Optional.of(message));
            return this.builder;
        }

        public Builder<MESSAGE, SCOPE> invokeMethod(Predicate<InvokeMethod> filter, MESSAGE message) {
            if (filter == null) {
                throw new IllegalArgumentException("filter==null");
            }
            this.append(ev -> {
                if (ev instanceof InvokeMethod && filter.test((InvokeMethod)ev)) {
                    return Optional.of(message);
                }
                return Optional.empty();
            });
            return this.builder;
        }

        public Builder<MESSAGE, SCOPE> invokeIndy(Predicate<InvokeDynamicCall> filter, MESSAGE message) {
            if (filter == null) {
                throw new IllegalArgumentException("filter==null");
            }
            this.append(ev -> {
                if (ev instanceof InvokeDynamicCall) {
                    return filter.test((InvokeDynamicCall)ev) ? Optional.of(message) : Optional.empty();
                }
                return Optional.empty();
            });
            return this.builder;
        }

        public Builder<MESSAGE, SCOPE> invoke(MESSAGE message, Predicate<Invoke<?>> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter==null");
            }
            this.append(ev -> {
                if (ev instanceof Invoke) {
                    return filter.test((Invoke)ev) ? Optional.of(message) : Optional.empty();
                }
                return Optional.empty();
            });
            return this.builder;
        }

        public Builder<MESSAGE, SCOPE> field(MESSAGE message, Predicate<FieldAccess> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter==null");
            }
            this.append(ev -> {
                if (ev instanceof FieldAccess) {
                    return filter.test((FieldAccess)ev) ? Optional.of(message) : Optional.empty();
                }
                return Optional.empty();
            });
            return this.builder;
        }
    }

    public static class Builder<MESSAGE, SCOPE> {
        private final List<Function<SecurAccess<?, SCOPE>, Optional<Tuple2<MESSAGE, Boolean>>>> validators = new ArrayList();

        public SecurityFilters<MESSAGE, SCOPE> build() {
            return new SecurityFilters<MESSAGE, SCOPE>(this.validators);
        }

        public AllowBuilder<MESSAGE, SCOPE> allow() {
            return new AllowBuilder(this);
        }

        public Builder<MESSAGE, SCOPE> allow(Consumer<AllowBuilder<MESSAGE, SCOPE>> conf) {
            if (conf == null) {
                throw new IllegalArgumentException("conf==null");
            }
            conf.accept(new AllowBuilder(this));
            return this;
        }

        public DenyBuilder<MESSAGE, SCOPE> deny() {
            return new DenyBuilder(this);
        }

        public Builder<MESSAGE, SCOPE> deny(Consumer<DenyBuilder<MESSAGE, SCOPE>> conf) {
            if (conf == null) {
                throw new IllegalArgumentException("conf==null");
            }
            conf.accept(new DenyBuilder(this));
            return this;
        }
    }
}

