/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.sec;

import java.util.ArrayList;
import java.util.List;
import xyz.cofe.fn.Tuple2;
import xyz.cofe.trambda.LambdaDump;
import xyz.cofe.trambda.LambdaNode;
import xyz.cofe.trambda.bc.cls.CMethod;
import xyz.cofe.trambda.bc.mth.MFieldInsn;
import xyz.cofe.trambda.bc.mth.MethodByteCode;
import xyz.cofe.trambda.bc.mth.OpCode;
import xyz.cofe.trambda.sec.SecurAccess;
import xyz.cofe.trambda.sec.TypeDesc;

public class FieldAccess
extends SecurAccess<MFieldInsn, Tuple2<LambdaDump, LambdaNode>> {
    public FieldAccess(MFieldInsn fieldInsn, Tuple2<LambdaDump, LambdaNode> methodDef) {
        super(fieldInsn, methodDef);
    }

    public FieldAccess(FieldAccess sample) {
        super((MFieldInsn)sample.instruction, (Tuple2)sample.scope);
    }

    @Override
    public FieldAccess clone() {
        return new FieldAccess(this);
    }

    public static List<FieldAccess> inspectField(LambdaDump mdef) {
        if (mdef == null) {
            throw new IllegalArgumentException("mdef==null");
        }
        ArrayList<FieldAccess> result = new ArrayList<FieldAccess>();
        FieldAccess.inspectField(result, mdef);
        return result;
    }

    private static void inspectField(List<FieldAccess> result, LambdaDump dump) {
        if (dump == null) {
            throw new IllegalArgumentException("dump==null");
        }
        if (result == null) {
            throw new IllegalArgumentException("result==null");
        }
        LambdaNode lnode = dump.getLambdaNode();
        if (lnode == null) {
            throw new IllegalArgumentException("dump.getLambdaNode()==null");
        }
        lnode.walk().tree().forEach(t -> {
            List<MethodByteCode> byteCodes;
            LambdaNode node = (LambdaNode)t.getNode();
            CMethod meth = node.getMethod();
            List<MethodByteCode> list = byteCodes = meth != null ? meth.getMethodByteCodes() : null;
            if (byteCodes != null) {
                for (MethodByteCode bc : byteCodes) {
                    if (bc == null || !(bc instanceof MFieldInsn)) continue;
                    result.add(new FieldAccess((MFieldInsn)bc, (Tuple2<LambdaDump, LambdaNode>)Tuple2.of((Object)dump, (Object)node)));
                }
            }
        });
    }

    public String getOwner() {
        if (((MFieldInsn)this.instruction).getOwner() != null) {
            return ((MFieldInsn)this.instruction).getOwner().replace("/", ".");
        }
        return "?";
    }

    public String getFieldName() {
        if (((MFieldInsn)this.instruction).getName() != null) {
            return ((MFieldInsn)this.instruction).getName();
        }
        return "?";
    }

    public TypeDesc getFieldType() {
        if (((MFieldInsn)this.instruction).getDescriptor() != null) {
            return TypeDesc.parse(((MFieldInsn)this.instruction).getDescriptor());
        }
        return TypeDesc.undefined;
    }

    public Operation getOperation() {
        for (Operation o : Operation.values()) {
            if (o.opcode != ((MFieldInsn)this.instruction).getOpcode()) continue;
            return o;
        }
        return Operation.Undefined;
    }

    public boolean isStatic() {
        return ((MFieldInsn)this.instruction).getOpcode() == OpCode.GETSTATIC.code || ((MFieldInsn)this.instruction).getOpcode() == OpCode.PUTSTATIC.code;
    }

    public boolean isField() {
        return ((MFieldInsn)this.instruction).getOpcode() == OpCode.GETFIELD.code || ((MFieldInsn)this.instruction).getOpcode() == OpCode.PUTFIELD.code;
    }

    public boolean isReadAccess() {
        return ((MFieldInsn)this.instruction).getOpcode() == OpCode.GETSTATIC.code || ((MFieldInsn)this.instruction).getOpcode() == OpCode.GETFIELD.code;
    }

    public boolean isWriteAccess() {
        return ((MFieldInsn)this.instruction).getOpcode() == OpCode.PUTSTATIC.code || ((MFieldInsn)this.instruction).getOpcode() == OpCode.PUTFIELD.code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("field");
        if (this.isStatic()) {
            sb.append(" static");
        }
        if (this.isReadAccess()) {
            sb.append(" read");
        } else if (this.isWriteAccess()) {
            sb.append(" write");
        }
        sb.append(" ").append(this.getFieldName()).append(" : ").append(this.getFieldType());
        sb.append(" of ").append(this.getOwner());
        return sb.toString();
    }

    public static enum Operation {
        Undefined(-1),
        GetStatic(OpCode.GETSTATIC.code),
        PutStatic(OpCode.PUTSTATIC.code),
        GetField(OpCode.GETFIELD.code),
        PutField(OpCode.PUTFIELD.code);

        public final int opcode;

        private Operation(int opcode) {
            this.opcode = opcode;
        }
    }
}

