/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationDef;
import xyz.cofe.trambda.bc.ann.GetAnnotationByteCodes;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MTryCatchAnnotation
extends MAbstractBC
implements ByteCode,
AnnotationDef,
GetAnnotationByteCodes,
MethodWriter {
    private static final long serialVersionUID = 1L;
    protected int typeRef;
    protected String typePath;
    protected String descriptor;
    protected boolean visible;
    protected List<AnnotationByteCode> annotationByteCodes;

    public MTryCatchAnnotation() {
    }

    public MTryCatchAnnotation(int typeRef, String typePath, String descriptor, boolean visible) {
        this.typeRef = typeRef;
        this.typePath = typePath;
        this.descriptor = descriptor;
        this.visible = visible;
    }

    public MTryCatchAnnotation(MTryCatchAnnotation sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.typePath = sample.typePath;
        this.typeRef = sample.typeRef;
        this.descriptor = sample.descriptor;
        this.visible = sample.visible;
        if (sample.annotationByteCodes != null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
            for (AnnotationByteCode b : sample.annotationByteCodes) {
                if (b != null) {
                    this.annotationByteCodes.add(b.clone());
                    continue;
                }
                this.annotationByteCodes.add(null);
            }
        }
    }

    @Override
    public MTryCatchAnnotation clone() {
        return new MTryCatchAnnotation(this);
    }

    public int getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(int typeRef) {
        this.typeRef = typeRef;
    }

    public String getTypePath() {
        return this.typePath;
    }

    public void setTypePath(String typePath) {
        this.typePath = typePath;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return MTryCatchAnnotation.class.getSimpleName() + " typeRef=" + this.typeRef + " typePath=" + this.typePath + " descriptor=" + this.descriptor + " visible=" + this.visible;
    }

    @Override
    public List<AnnotationByteCode> getAnnotationByteCodes() {
        if (this.annotationByteCodes == null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
        }
        return this.annotationByteCodes;
    }

    public void setAnnotationByteCodes(List<AnnotationByteCode> byteCodes) {
        this.annotationByteCodes = byteCodes;
    }

    @Override
    public Eterable<ByteCode> nodes() {
        if (this.annotationByteCodes != null) {
            return Eterable.of(this.annotationByteCodes);
        }
        return Eterable.empty();
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        String tp = this.getTypePath();
        AnnotationVisitor av = v.visitTryCatchAnnotation(this.getTypeRef(), tp != null ? TypePath.fromString((String)tp) : null, this.getDescriptor(), this.isVisible());
        List<AnnotationByteCode> abody = this.annotationByteCodes;
        if (abody != null) {
            int i = -1;
            for (AnnotationByteCode ab : abody) {
                ++i;
                if (ab != null) {
                    ab.write(av);
                    continue;
                }
                throw new IllegalStateException("annotationByteCodes[" + i + "]==null");
            }
        }
    }
}

